/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.xml;

import de.scandio.confluence.plugins.diary.xml.XmlDiaryMacro;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class XmlParser {
    private final Document document;

    public XmlParser(String xml) {
        this.document = Jsoup.parse((String)xml, (String)"", (Parser)Parser.xmlParser());
        this.document.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).indentAmount(0).prettyPrint(false);
    }

    public boolean hasMacrosOrTasklists() {
        boolean hasTasklists = this.document.getElementsByTag("ac:task-list").size() > 0;
        boolean hasInlineComments = this.document.getElementsByTag("ac:inline-comment-marker").size() > 0;
        return hasInlineComments || hasTasklists || this.getMacros().size() > 0;
    }

    public Elements getMacros() {
        return this.document.getElementsByTag("ac:structured-macro");
    }

    private Stream<XmlDiaryMacro> getDiaryMacrosStream() {
        return this.getMacros().stream().filter(macro -> "diary".equals(macro.attr("ac:name"))).map(XmlDiaryMacro::new);
    }

    public List<XmlDiaryMacro> getDiaryMacros() {
        return this.getDiaryMacrosStream().collect(Collectors.toList());
    }

    public Optional<XmlDiaryMacro> getDiaryById(String id) {
        Optional<XmlDiaryMacro> result = id == null ? Optional.empty() : this.getDiaryMacrosStream().filter(diaryMacro -> id.equals(diaryMacro.getId())).findFirst();
        return result;
    }

    public String toString() {
        return this.document.toString();
    }
}

