/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.util;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.spring.container.ContainerManager;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;

public class Permissions {
    private static PermissionManager permissionManager;

    private Permissions() {
    }

    private static PermissionManager getPermissionManager() {
        if (permissionManager == null) {
            permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return permissionManager;
    }

    public static boolean canCurrentUserEdit(Object object) {
        boolean result = false;
        PermissionManager permissionManager = Permissions.getPermissionManager();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null && permissionManager != null && object != null) {
            result = permissionManager.hasPermission(currentUser, Permission.EDIT, object);
        }
        return result;
    }

    public static void throwIfCurrentUserCanNotEdit(Object object) throws ExceptionWithoutStacktrace {
        if (!Permissions.canCurrentUserEdit(object)) {
            throw new ExceptionWithoutStacktrace("Current user has no edit permissions!");
        }
    }
}

