/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.confluence.util.diffs.Merger;
import com.atlassian.confluence.util.diffs.MergerManager;
import com.atlassian.spring.container.ContainerManager;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;

public class ContentEntityUtils {
    private static final String VERSION_NOT_FOUND_MSG = "Could not find version %d of %s with id %d";
    private static final String ENTITY_NOT_FOUND_MSG = "Could not get %s with id %d";
    private static PageManager pageManager;
    private static MergerManager mergerManager;

    private ContentEntityUtils() {
    }

    private static PageManager getPageManager() {
        if (pageManager == null) {
            pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager");
        }
        return pageManager;
    }

    private static Merger getMerger() {
        if (mergerManager == null) {
            mergerManager = (MergerManager)ContainerManager.getComponent((String)"mergerManager");
        }
        return mergerManager.getMerger();
    }

    public static ContentEntityObject getContentEntityOrThrow(long contentId, String contentType) throws ExceptionWithoutStacktrace {
        ContentEntityObject contentEntity = ContentEntityUtils.getPageManager().getById(contentId);
        if (contentEntity == null) {
            String message = String.format(ENTITY_NOT_FOUND_MSG, contentType, contentId);
            throw new ExceptionWithoutStacktrace(message);
        }
        return contentEntity;
    }

    public static ContentEntityObject getContentEntityOrThrow(long contentId, String contentType, int version) throws ExceptionWithoutStacktrace {
        ContentEntityObject contentEntity = ContentEntityUtils.getContentEntityOrThrow(contentId, contentType);
        ContentEntityObject contentEntityInCorrectVersion = ContentEntityUtils.getPageManager().getOtherVersion(contentEntity, version);
        if (contentEntityInCorrectVersion == null) {
            String message = String.format(VERSION_NOT_FOUND_MSG, version, contentType, contentId);
            throw new ExceptionWithoutStacktrace(message);
        }
        return contentEntityInCorrectVersion;
    }

    public static void saveEditedContentEntity(ContentEntityObject contentEntity, String body, String versionComment) {
        ContentEntityObject originalContentEntity = (ContentEntityObject)contentEntity.clone();
        contentEntity.setBodyAsString(body);
        contentEntity.setVersionComment(versionComment);
        DefaultSaveContext saveContext = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(false)).updateLastModifier(true).suppressEvents(false)).build();
        ContentEntityUtils.getPageManager().saveContentEntity(contentEntity, originalContentEntity, (SaveContext)saveContext);
    }

    private static MergeResult mergeOrThrow(String base, String left, String right) throws ExceptionWithoutStacktrace {
        MergeResult result = ContentEntityUtils.getMerger().mergeContent(base, left, right);
        if (result.hasConflicts()) {
            throw new ExceptionWithoutStacktrace("Merging conflict.");
        }
        return result;
    }

    public static boolean saveOrMergeEditedContentEntity(ContentEntityObject inCurrentVersion, ContentEntityObject inRequestedVersion, String body, String versionComment, String errorMessage) throws ExceptionWithoutStacktrace {
        boolean wasMerged = false;
        if (inCurrentVersion.getVersion() == inRequestedVersion.getVersion()) {
            ContentEntityUtils.saveEditedContentEntity(inCurrentVersion, body, versionComment);
        } else {
            try {
                MergeResult mergeResult = ContentEntityUtils.mergeOrThrow(inRequestedVersion.getBodyAsString(), body, inCurrentVersion.getBodyAsString());
                ContentEntityUtils.saveEditedContentEntity(inCurrentVersion, mergeResult.getMergedContent(), versionComment);
                wasMerged = true;
            }
            catch (ExceptionWithoutStacktrace e) {
                throw new ExceptionWithoutStacktrace(errorMessage);
            }
        }
        return wasMerged;
    }
}

