/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.actions;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import de.scandio.confluence.plugins.diary.actions.EditEntryActionResult;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.ContentEntityUtils;
import de.scandio.confluence.plugins.diary.util.EntryPreview;
import de.scandio.confluence.plugins.diary.util.Permissions;
import de.scandio.confluence.plugins.diary.xml.XmlDiaryMacro;
import de.scandio.confluence.plugins.diary.xml.XmlParser;
import java.io.Serializable;
import java.util.Optional;

public class EditEntryAction {
    private static final String I18N_EDITED_DIARY_ENTRY = "de.scandio.diary.version-comment.edited-entry";
    private static final String DIARY_NOT_FOUND_MSG = "Diary with id %s not found in version %d of page %d";
    private static final String MERGE_ERROR_MSG = "<p>This page was edited while you were editing your entry. The page was edited in such a way that your Diary was unable to merge the edited entry into the new version of the page.</p><p>Please <a href=\"\" class=\"page-reloader\">reload the page</a> and try editing the entry again.</p>";
    private final int version;
    private final int entryId;
    private final long id;
    private final String content;
    private final String macroId;
    private final String contentType;
    private final FormatConverter formatConverter;
    private final I18nResolver i18nResolver;

    public EditEntryAction(int version, int entryId, long id, String content, String macroId, String contentType, FormatConverter formatConverter, I18nResolver i18nResolver) {
        this.version = version;
        this.entryId = entryId;
        this.id = id;
        this.content = content;
        this.macroId = macroId;
        this.contentType = contentType;
        this.formatConverter = formatConverter;
        this.i18nResolver = i18nResolver;
    }

    public EditEntryActionResult execute() throws ExceptionWithoutStacktrace, XhtmlException {
        ContentEntityObject inCurrentVersion = ContentEntityUtils.getContentEntityOrThrow(this.id, this.contentType);
        ContentEntityObject inRequestedVersion = ContentEntityUtils.getContentEntityOrThrow(this.id, this.contentType, this.version);
        Permissions.throwIfCurrentUserCanNotEdit(inCurrentVersion);
        XmlParser xmlParser = new XmlParser(inRequestedVersion.getBodyAsString());
        Optional<XmlDiaryMacro> maybeDiary = xmlParser.getDiaryById(this.macroId);
        if (!maybeDiary.isPresent()) {
            String message = String.format(DIARY_NOT_FOUND_MSG, this.macroId, this.version, this.id);
            throw new ExceptionWithoutStacktrace(message);
        }
        XmlDiaryMacro diary = maybeDiary.get();
        String xml = this.formatConverter.convertToStorageFormat(this.content, (RenderContext)inRequestedVersion.toPageContext());
        String renderedHtml = this.formatConverter.convertToViewFormat(this.content, (RenderContext)inRequestedVersion.toPageContext());
        diary.setEntryContent(this.entryId, xml);
        String preview = this.i18nResolver.getText(I18N_EDITED_DIARY_ENTRY, new Serializable[]{EntryPreview.getEntryPreview(this.content)});
        boolean wasMerged = ContentEntityUtils.saveOrMergeEditedContentEntity(inCurrentVersion, inRequestedVersion, xmlParser.toString(), preview, MERGE_ERROR_MSG);
        EditEntryActionResult result = new EditEntryActionResult(xml, renderedHtml, wasMerged, inCurrentVersion.getVersion());
        return result;
    }
}

