export const $ = AJS.$;
export const ready = AJS.toInit;
export const flag = AJS.flag;

export const contextPath = AJS.Meta.get('context-path');
export const pageTitle = AJS.Meta.get('page-title');
export const dateFormat = AJS.Meta.get('date.format').toUpperCase();
export const spaceKey = AJS.Meta.get('space-key');
export const contentType = AJS.Meta.get('content-type');

export const currentUser = {
	avatarURL: AJS.Meta.get('current-user-avatar-uri-reference'),
	displayName: AJS.Meta.get('user-display-name'),
	userName: AJS.Meta.get('remote-user'),
	userKey: AJS.Meta.get('remote-user-key')
};

export const restEndpoints = {
	getUser: contextPath + '/rest/api/user?username=',
	getCurrentUser: contextPath + '/rest/api/user/current',
	saveEntry: contextPath + '/rest/diary/1.0/entry/save',
	editEntry: contextPath + '/rest/diary/1.0/entry/edit',
	deleteEntry: contextPath + '/rest/diary/1.0/entry/delete',
	getTemplates: contextPath + '/rest/experimental/template/page?limit=200',
	getEditorFormat: (contentId, version, macroId, entryId) =>
		`${contextPath}/rest/diary/1.0/entry/editorformat?contentid=${contentId}&version=${version}&macroid=${macroId}&entryid=${entryId}&type=${contentType}`
};
