/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.util;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.renderer.RenderContext;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ConversionContextUtil {
    private ConversionContextUtil() {
    }

    public static int getPageVersion(ConversionContext conversionContext) {
        int result = -1;
        ContentEntityObject entity = conversionContext.getEntity();
        if (entity != null) {
            result = entity.getVersion();
        }
        return result;
    }

    public static String getPageID(ConversionContext conversionContext) {
        ContentEntityObject ceo = conversionContext.getEntity();
        return ceo == null ? null : ceo.getContentId().serialise();
    }

    public static String getMacroID(ConversionContext conversionContext) {
        String macroID;
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Optional option = macroDefinition.getMacroIdentifier();
        try {
            macroID = ((MacroId)option.get()).getId();
        }
        catch (NoSuchElementException e) {
            macroID = null;
        }
        return macroID;
    }

    public static String getTemplateInEditorFormat(String templateIdString, ConversionContext conversionContext, PageTemplateManager pageTemplateManager, FormatConverter formatConverter) {
        long templateId;
        PageTemplate maybePageTemplate;
        String result = null;
        if (templateIdString != null && (maybePageTemplate = pageTemplateManager.getPageTemplate(templateId = Long.parseLong(templateIdString))) != null) {
            String templateContent = maybePageTemplate.getContent();
            result = formatConverter.convertToEditorFormat(templateContent, (RenderContext)conversionContext.getPageContext());
        }
        return result == null ? null : result.trim();
    }
}

