/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.sal.api.message.I18nResolver;
import de.scandio.confluence.plugins.diary.actions.DeleteEntryAction;
import de.scandio.confluence.plugins.diary.actions.EditEntryAction;
import de.scandio.confluence.plugins.diary.actions.EditEntryActionResult;
import de.scandio.confluence.plugins.diary.actions.GetEditorFormatAction;
import de.scandio.confluence.plugins.diary.actions.SaveNewEntryAction;
import de.scandio.confluence.plugins.diary.actions.SaveNewEntryActionResult;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.ContentEntityUtils;
import de.scandio.confluence.plugins.diary.xml.XmlParser;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;

@Path(value="/entry")
public class DiaryRestResource {
    private final AccessModeService accessModeService;
    private final FormatConverter formatConverter;
    private final I18nResolver i18nResolver;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/save")
    public Response saveEntry(Map<String, Object> parameters) {
        Response response;
        try {
            long id = Long.parseLong((String)parameters.get("contentid"));
            String content = (String)parameters.get("content");
            String contentId = (String)parameters.get("macroid");
            String userkey = (String)parameters.get("userkey");
            String contentType = (String)parameters.get("type");
            SaveNewEntryActionResult result = new SaveNewEntryAction(id, content, contentId, userkey, contentType, this.formatConverter, this.i18nResolver).execute();
            response = this.buildSaveEntrySuccessResponse(result);
        }
        catch (XhtmlException | ExceptionWithoutStacktrace e) {
            response = this.buildErrorResponse(e.getMessage());
        }
        return response;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/editorformat")
    public Response getEditorFormat(@QueryParam(value="contentid") long id, @QueryParam(value="version") int version, @QueryParam(value="macroid") String macroId, @QueryParam(value="entryid") int entryId, @QueryParam(value="type") String contentType) {
        Response response;
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            response = this.buildReadOnlyResponse();
        } else {
            try {
                String editorFormat = new GetEditorFormatAction(id, entryId, version, macroId, contentType, this.formatConverter).execute();
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("content", editorFormat);
                result.put("status", "success");
                response = Response.ok(result).build();
            }
            catch (ExceptionWithoutStacktrace e) {
                response = this.buildErrorResponse(e.getMessage());
            }
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/edit")
    public Response editEntry(Map<String, Object> parameters) {
        Response response;
        try {
            int version = Integer.parseInt((String)parameters.get("version"));
            int entryId = Integer.parseInt((String)parameters.get("entryid"));
            long contentId = Long.parseLong((String)parameters.get("contentid"));
            String content = (String)parameters.get("content");
            String macroId = (String)parameters.get("macroid");
            String contentType = (String)parameters.get("type");
            EditEntryActionResult result = new EditEntryAction(version, entryId, contentId, content, macroId, contentType, this.formatConverter, this.i18nResolver).execute();
            response = this.buildEditEntrySuccessResponse(result);
        }
        catch (XhtmlException | ExceptionWithoutStacktrace e) {
            response = this.buildErrorResponse(e.getMessage());
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/delete")
    public Response deleteEntry(Map<String, Object> parameters) {
        Response response;
        try {
            int version = Integer.parseInt((String)parameters.get("version"));
            int entryId = Integer.parseInt((String)parameters.get("entryid"));
            long contentId = Long.parseLong((String)parameters.get("contentid"));
            String macroId = (String)parameters.get("macroid");
            String contentType = (String)parameters.get("type");
            boolean merged = new DeleteEntryAction(version, entryId, contentId, macroId, contentType, this.i18nResolver).execute();
            int newPageVersion = ContentEntityUtils.getContentEntityOrThrow(contentId, contentType).getVersion();
            response = this.buildDeleteEntrySuccessResponse(merged, newPageVersion);
        }
        catch (ExceptionWithoutStacktrace e) {
            response = this.buildErrorResponse(e.getMessage());
        }
        return response;
    }

    private Response buildReadOnlyResponse() {
        return this.buildErrorResponse("Confluence is in read-only mode.");
    }

    private Response buildErrorResponse(String message) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("status", "error");
        responseMap.put("message", message);
        return Response.ok(responseMap).build();
    }

    private Response buildSaveEntrySuccessResponse(SaveNewEntryActionResult result) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("status", "success");
        responseMap.put("hasMacros", new XmlParser(result.getXml()).hasMacrosOrTasklists());
        responseMap.put("html", result.getHtml());
        responseMap.put("index", result.getNewEntryIndex());
        responseMap.put("version", result.getVersion());
        return Response.ok(responseMap).build();
    }

    private Response buildEditEntrySuccessResponse(EditEntryActionResult result) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("status", "success");
        responseMap.put("hasMacros", new XmlParser(result.getXml()).hasMacrosOrTasklists());
        responseMap.put("html", result.getHtml());
        responseMap.put("merged", result.wasMerged());
        responseMap.put("version", result.getVersion());
        return Response.ok(responseMap).build();
    }

    private Response buildDeleteEntrySuccessResponse(boolean merged, int version) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("status", "success");
        responseMap.put("merged", merged);
        responseMap.put("version", version);
        return Response.ok(responseMap).build();
    }

    @Generated
    public DiaryRestResource(AccessModeService accessModeService, FormatConverter formatConverter, I18nResolver i18nResolver) {
        this.accessModeService = accessModeService;
        this.formatConverter = formatConverter;
        this.i18nResolver = i18nResolver;
    }
}

