export function hasParentWithClass(e, className) {
	let isInside = false;

	while ((e = e && e.parentNode) && !isInside) {
		isInside = e.classList && e.classList.contains(className);
	}

	return isInside;
}

export function isInsideMainContent(e) {
	let isInsideMainContent = false;

	while ((e = e && e.parentNode) && !isInsideMainContent) {
		isInsideMainContent =
			e.attributes && e.attributes.id && e.attributes.id.value === 'main-content' &&
			e.classList && e.classList.contains('wiki-content');
	}

	return isInsideMainContent;
}