
import {$} from './environment';

export function activateAnchorLinkHandler() {
	const anchorLink = window.location.hash;

	if (anchorLink) {
		const withoutHash = anchorLink.substring(anchorLink.indexOf('#') + 1);
		const split = withoutHash.split('+');

		// expecting anchor link to be: #MACROID+ENTRYINDEX
		if (split.length === 2) {
			// wait until the diary is rendered
			AJS.bind('diary.' + split[0] + '.rendered', () => {
				const $entry = $('[data-name=\'' + withoutHash + '\']').closest('.entry');
				scrollToEntryAndFocus($entry);
			});
		}
	}
}

export function scrollToEntryAndFocus($entry, callback) {
	$('.entry.focused')
		.removeClass('focused')
		.removeClass('focused-bubble')
		.removeClass('focused-simple');

	$entry.addClass('focused');

	if ($entry.hasClass('entry-bubble')) {
		$entry.addClass('focused-bubble');
	} else {
		$entry.addClass('focused-simple');
	}

	const scrollTop = $(window).scrollTop();
	const bodyHeight = $('body').height();

	// We only want to scroll to the entry, if it is not inside the visible viewport + tolerance.
	// Tolerance meaning, we will still scroll if the entry is in the top or bottom 50px range.
	const minViewport = scrollTop + 50;
	const maxViewport = scrollTop + bodyHeight - 50;

	const entryOffsetHeight = $entry.offset().top;
	const entryIsInViewPort = entryOffsetHeight > minViewport && entryOffsetHeight < maxViewport;

	if (entryIsInViewPort) {
		callback && callback();
	} else {
		$('html, body').animate({
			scrollTop: entryOffsetHeight - 100,
			duration: 1000
		}).promise().then(function() {
			callback && callback();
		});
	}
}

export function bindAnchorLinks(diary) {
	const entries = diary.querySelector('.entries').children;
	const length = entries.length;

	for (let i = 0; i < length; i++) {
		const entry = entries[i];
		activateAnchorOnClick($(entry));
	}
}

export function activateAnchorOnClick($entry) {
	const $entryAnchor = $entry.find('.entry-anchor').first();

	$entryAnchor.click(e => {
		e.preventDefault();
		scrollToEntryAndFocus($entry);
		window.location.hash = $entryAnchor.attr('href');
	});
}
