import {BUBBLE_ENTRY_TEMPLATE} from './templates/bubbleEntry.template';
import {SIMPLE_ENTRY_TEMPLATE} from './templates/simpleEntry.template';
import {BUBBLE_EDITOR_TEMPLATE} from './templates/bubbleEditor.template';
import {SIMPLE_EDITOR_TEMPLATE} from './templates/simpleEditor.template';
import {$} from '../util/environment';

export function has24hTimeFormat(diary) {
	return diary.dataset.timeformat === '24h';
}

export function isTimeVisible(diary) {
	return diary.dataset.time === 'true';
}

export function userHasEditPermission(diary) {
	return diary.dataset.canEdit === 'true';
}

export function hasEntryContentTemplate(diary) {
	return !!diary.querySelector('.entry-template');
}

export function hasDescendingOrder(diary) {
	return diary.dataset.order === 'descending';
}

export function hasAscendingOrder(diary) {
	return !hasDescendingOrder(diary);
}

export function getEntryContentTemplate(diary) {
	// TODO what is this? use template <script> instead and find a way to fix this
	// https://stackoverflow.com/questions/4912586/explanation-of-script-type-text-template-script
	function unwrapContentLayouts(template) {
		const $template = $('<wrapper>' + template + '</wrapper>');

		$template.find('.contentLayout2')
			.children().children().children().children()
			.unwrap().unwrap().unwrap().unwrap();

		return $template.html();
	}

	const rawTemplate = diary.querySelector('.entry-template').innerHTML;
	return unwrapContentLayouts(rawTemplate);
}

export function getEntryUiTemplate(diary) {
	let entryTemplate;

	switch (diary.dataset.style) {
		case 'bubble':
			entryTemplate = BUBBLE_ENTRY_TEMPLATE;
			break;
		case 'simple':
			entryTemplate = SIMPLE_ENTRY_TEMPLATE;
			break;
		default:
			entryTemplate = SIMPLE_ENTRY_TEMPLATE;
			break;
	}

	return entryTemplate;
}

export function getEditorUiTemplate(diary) {
	let entryTemplate;

	switch (diary.dataset.style) {
		case 'bubble':
			entryTemplate = BUBBLE_EDITOR_TEMPLATE;
			break;
		case 'simple':
			entryTemplate = SIMPLE_EDITOR_TEMPLATE;
			break;
		default:
			entryTemplate = SIMPLE_EDITOR_TEMPLATE;
			break;
	}

	return entryTemplate;
}
