import {
	initTimeParameterClickListener,
	initTitleParameterClickListener,
	renderEditorPositionI18n,
	renderOrderI18n,
	renderStyleI18n,
	renderTemplateIdInput
} from './macrobrowser/parameters';

function beforeParamsSet(params) {
	renderOrderI18n();
	renderEditorPositionI18n();
	renderStyleI18n();
	initTimeParameterClickListener(params);
	initTitleParameterClickListener(params);
	renderTemplateIdInput(params);
	return params;
}

AJS.toInit(function() {
	AJS.MacroBrowser && AJS.MacroBrowser.setMacroJsOverride('diary', {
		beforeParamsSet: beforeParamsSet
	});
});
