/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.actions;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.renderer.RenderContext;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.ContentEntityUtils;
import de.scandio.confluence.plugins.diary.util.Permissions;
import de.scandio.confluence.plugins.diary.xml.XmlDiaryMacro;
import de.scandio.confluence.plugins.diary.xml.XmlParser;
import java.util.Optional;

public class GetEditorFormatAction {
    private static final String DIARY_NOT_FOUND_MSG = "Diary with id %s not found in %s with id %d and version %d.";
    private final long contentEntityId;
    private final int entryId;
    private final int version;
    private final String macroId;
    private final String contentType;
    private final FormatConverter formatConverter;

    public GetEditorFormatAction(long contentEntityId, int entryId, int version, String macroId, String contentType, FormatConverter formatConverter) {
        this.contentEntityId = contentEntityId;
        this.entryId = entryId;
        this.version = version;
        this.macroId = macroId;
        this.formatConverter = formatConverter;
        this.contentType = contentType;
    }

    public String execute() throws ExceptionWithoutStacktrace {
        ContentEntityObject contentEntity = ContentEntityUtils.getContentEntityOrThrow(this.contentEntityId, this.contentType, this.version);
        Permissions.throwIfCurrentUserCanNotEdit(contentEntity);
        XmlParser xmlParser = new XmlParser(contentEntity.getBodyAsString());
        Optional<XmlDiaryMacro> maybeDiary = xmlParser.getDiaryById(this.macroId);
        if (!maybeDiary.isPresent()) {
            String message = String.format(DIARY_NOT_FOUND_MSG, this.macroId, this.contentType, this.contentEntityId, this.version);
            throw new ExceptionWithoutStacktrace(message);
        }
        XmlDiaryMacro diary = maybeDiary.get();
        String content = diary.getEntryContent(this.entryId);
        String result = this.formatConverter.convertToEditorFormat(content, (RenderContext)contentEntity.toPageContext());
        return result;
    }
}

