import {restEndpoints} from '../util/environment';
import {ajax} from './ajax';

/**
 * Used for preview mode as AJS.Meta user information does not exist in preview mode.
 * @param successCallback
 * @param errorCallback
 */
export function getCurrentUser(successCallback, errorCallback) {
	ajax({
		type: 'GET',
		url: restEndpoints.getCurrentUser,
		ifModified: true
	}, function(response) {
		const result = {
			userName: response.username,
			displayName: response.displayName,
			avatarURL: response.profilePicture.path,
			userKey: response.userKey
		};
		successCallback(result);
	}, errorCallback);
}