
import {currentUser} from '../../../util/environment';
import {saveEntry} from '../../../rest/saveEntry';
import {
	showCantSaveEmptyEntryFlag,
	showRestBadStatusFlag,
	showRestInvalidResponseFlag
} from '../../../util/flags/saveNewEntryFlags';

export function createNewEntrySaveHandler(diary) {
	return function() {
		const content = AJS.Rte.getEditor() && AJS.Rte.getEditor().getContent();

		if (content && content !== '<p><br /></p>') {
			const data = {
				content: content,
				contentid: diary.dataset.pageId,
				macroid: diary.id,
				userkey: currentUser.userKey
			};

			saveEntry(data, response => {
				if (response.status === 'success') {
					window.location.hash = '#' + diary.id + '+' + response.index;
					location.reload();
				} else {
					showRestBadStatusFlag(response);
				}
			}, showRestInvalidResponseFlag);
		} else {
			showCantSaveEmptyEntryFlag();
		}
	};
}
