import {dateFormat} from '../../util/environment';
import moment from 'moment';
import {has24hTimeFormat, isTimeVisible} from '../dom-diary-util';

// TODO only generate html here with classes and fill data with JS


export const SIMPLE_ENTRY_TEMPLATE = (entry, diary) => `
<li class="entry entry-simple" data-index="${entry.index}">
  <div class="entry-content">
    <div class="entry-header">
      <div class="meta">
        <span class="username">
          <a class="confluence-userlink" data-username="${entry.userName}" href="${entry.userHref}">${entry.displayName}</a>
        </span>
       
        <span class="meta-seperator">· </span>

        <a class="entry-anchor" data-name="${diary.id}+${entry.index}" data-index="${entry.index}" href="#${diary.id}+${entry.index}">
          <span class="entry-date">${moment(entry.date).format(dateFormat)}</span>
          ${isTimeVisible(diary) ? `<span class="entry-time">· ${has24hTimeFormat(diary) ? entry.time : moment(entry.time, 'hh:mm').format('HH:mm A')}</span>` : ''}
        </a>
        
        <div class="menu-container" style="display: none;">
          <button class="share-button aui-button aui-button-subtle" title="${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.share')}">
            <span class="aui-icon aui-icon-small aui-iconfont-link">
              ${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.share')}
            </span>
          </button>
          <button class="edit-button aui-button aui-button-subtle" title="${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.edit')}">
            <span class="aui-icon aui-icon-small aui-iconfont-edit">
              ${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.edit')}
            </span>
          </button>
          <button class="delete-button aui-button aui-button-subtle" title="${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.delete')}">
            <span class="aui-icon aui-icon-small aui-iconfont-delete">
              ${AJS.I18n.getText('de.scandio.diary.macro.entry.menu.delete')}
            </span>
          </button>
        </div>
                        
      </div>   
    </div>
    <div class="body">
      <span class="scd-spinner aui-icon aui-icon-small aui-icon-wait">
        ${AJS.I18n.getText('de.scandio.diary.macro.entry.loading')}
      </span>
    </div>
  </div>
</li>
`;
