/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.xml;

import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.DiaryVelocityUtils;
import de.scandio.confluence.plugins.diary.xml.XmlEntry;
import java.util.HashMap;
import java.util.Optional;
import org.jsoup.nodes.Element;

public class XmlDiaryMacro {
    private static final int CONTENT_COLUMN_INDEX = 3;
    private final Element macro;

    public XmlDiaryMacro(Element macro) {
        this.macro = macro;
    }

    public String getId() {
        return this.macro.attr("ac:macro-id");
    }

    Optional<Element> getBody() {
        return this.macro.children().stream().filter(child -> child.tagName().equals("ac:rich-text-body")).findFirst();
    }

    private boolean hasAmountOfTableHeaders(Element table, int amount) {
        return table.getElementsByTag("tr").first().getElementsByTag("th").size() == amount;
    }

    private Optional<Element> findEntriesTable(Element body) {
        return body.getElementsByTag("table").stream().filter(table -> this.hasAmountOfTableHeaders((Element)table, 5)).findFirst();
    }

    private String renderNewTable(XmlEntry entry) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("entry", entry);
        return DiaryVelocityUtils.getRenderedTemplate("/diary/templates/new-table.vm", context);
    }

    public long addEntry(XmlEntry entry) throws ExceptionWithoutStacktrace {
        long newEntryIndex;
        Optional<Element> body = this.getBody();
        if (body.isPresent()) {
            Optional<Element> entriesTable = this.findEntriesTable(body.get());
            if (entriesTable.isPresent()) {
                Element tableBody = entriesTable.get().getElementsByTag("tbody").first();
                tableBody.append(entry.render());
                newEntryIndex = this.getEntriesSize(tableBody);
            } else {
                body.get().prepend(this.renderNewTable(entry));
                newEntryIndex = 1L;
            }
        } else {
            throw new ExceptionWithoutStacktrace("Unable to find ac:rich-text-body in storage format of diary with ID: \"" + this.getId() + "\".");
        }
        return newEntryIndex;
    }

    private long getEntriesSize(Element tableBody) {
        return tableBody.children().stream().filter(element -> element.tagName().equals("tr")).count() - 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element getEntry(int id) throws ExceptionWithoutStacktrace {
        if (id <= 0) {
            throw new ExceptionWithoutStacktrace("invalid entry id: " + id);
        }
        Optional<Element> body = this.getBody();
        if (body.isPresent()) {
            Optional<Element> entriesTable = this.findEntriesTable(body.get());
            if (entriesTable.isPresent()) {
                Element tableBody = entriesTable.get().getElementsByTag("tbody").first();
                try {
                    return tableBody.child(id);
                }
                catch (IndexOutOfBoundsException e) {
                    int amountOfEntries = tableBody.children().size() - 1;
                    String message = String.format("Entry with id %d not found. Diary has %s entries.", id, amountOfEntries);
                    throw new ExceptionWithoutStacktrace(message);
                }
            }
            String message = "The diary has no entry table.";
            throw new ExceptionWithoutStacktrace("The diary has no entry table.");
        }
        String message = "The diary has no ac:rich-text-body.";
        throw new ExceptionWithoutStacktrace("The diary has no ac:rich-text-body.");
    }

    public String deleteEntry(int id) throws ExceptionWithoutStacktrace {
        Element entry = this.getEntry(id);
        String content = entry.child(3).html();
        entry.remove();
        return content;
    }

    public String getEntryContent(int id) throws ExceptionWithoutStacktrace {
        return this.getEntry(id).child(3).html();
    }

    public void setEntryContent(int id, String newContent) throws ExceptionWithoutStacktrace {
        this.getEntry(id).child(3).html(newContent);
    }
}

