/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.macro;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.scandio.confluence.plugins.diary.html.DiaryRenderer;
import de.scandio.confluence.plugins.diary.util.ResourceUtil;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DiaryMacro
implements Macro {
    private final PageBuilderService pageBuilderService;
    private final PageTemplateManager pageTemplateManager;
    private final FormatConverter formatConverter;
    private final AccessModeService accessModeService;
    private final PluginLicenseManager pluginLicenseManager;
    private final VelocityHelperService velocityHelperService;

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) {
        String result;
        if (!this.isLicensed()) {
            result = this.velocityHelperService.getRenderedTemplate("/diary/templates/license-error.vm", new HashMap());
        } else if ("pdf".equalsIgnoreCase(conversionContext.getOutputType())) {
            result = this.renderDiaryForPdf(parameters, body);
        } else {
            ResourceUtil.requireCorrectResources(this.pageBuilderService, parameters);
            parameters.put("read-only", String.valueOf(this.accessModeService.isReadOnlyAccessModeEnabled()));
            result = new DiaryRenderer(parameters, body, conversionContext, this.pageTemplateManager, this.formatConverter).render();
        }
        return result;
    }

    private String renderDiaryForPdf(Map<String, String> parameters, String body) {
        String renderedDiary = "";
        Elements tables = Jsoup.parse((String)body).getElementsByTag("table");
        if (tables.size() > 0) {
            Element entriesTable = (Element)tables.get(0);
            Elements tableRows = entriesTable.getElementsByTag("tbody").first().children();
            tableRows.forEach(tableRow -> tableRow.children().last().remove());
            renderedDiary = entriesTable.toString();
        }
        return renderedDiary;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private boolean isLicensed() {
        return this.pluginLicenseManager.getLicense().isDefined() && !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    @Generated
    public DiaryMacro(PageBuilderService pageBuilderService, PageTemplateManager pageTemplateManager, FormatConverter formatConverter, AccessModeService accessModeService, PluginLicenseManager pluginLicenseManager, VelocityHelperService velocityHelperService) {
        this.pageBuilderService = pageBuilderService;
        this.pageTemplateManager = pageTemplateManager;
        this.formatConverter = formatConverter;
        this.accessModeService = accessModeService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.velocityHelperService = velocityHelperService;
    }
}

