import {$} from '../util/environment';

export function ajax(options, successCallback, errorCallback) {
	$.ajax(options)
		.done(function(data) {
			successCallback(data);
		})
		.fail(function(jqXHR) {
			if (jqXHR.message) {
				errorCallback(jqXHR.message);
			} else {
				const exceptionMessage = $(jqXHR.responseXML).find('message').text();
				errorCallback(exceptionMessage ? exceptionMessage : jqXHR.statusText);
			}
		});
}