import {$, I18n} from '../util/environment';
import {getTemplates} from '../rest/getTemplates';
import {showCantLoadTemplates} from '../util/flags/macrobrowserFlags';

function initToggleableParameter($checkbox, $inputToToggle, hideInitially) {
	if (hideInitially) {
		$inputToToggle.hide();
	}

	$checkbox.on('click', () => {
		if ($checkbox.attr('checked')) {
			$inputToToggle.show();
		} else {
			$inputToToggle.hide();
		}
	});
}

export function initTimeParameterClickListener(params) {
	const $checkbox = $('#macro-param-div-time input');
	const $timeFormatInput = $('#macro-param-div-timeformat');
	const hideInitially = params.time === 'false';
	initToggleableParameter($checkbox, $timeFormatInput, hideInitially);
}

export function initTitleParameterClickListener(params) {
	const $titleTextInput = $('#macro-param-div-title');
	const $checkbox = $('#macro-param-div-showtitle input');
	const hideInitially = !params.showtitle;
	initToggleableParameter($checkbox, $titleTextInput, hideInitially);
}

export function renderOrderI18n() {
	const $orderParamContainer = $('#macro-param-div-order');
	const descLabel = I18n.getText('de.scandio.diary.macro.parameters.order.descending');
	const ascLabel = I18n.getText('de.scandio.diary.macro.parameters.order.ascending');

	$orderParamContainer.find('option[value=descending]').text(descLabel);
	$orderParamContainer.find('option[value=ascending]').text(ascLabel);
}


export function renderEditorPositionI18n() {
	const $editorPositionParamContainer = $('#macro-param-div-editorposition');
	const topLabel = I18n.getText('de.scandio.diary.macro.parameters.editorposition.top');
	const bottomLabel = I18n.getText('de.scandio.diary.macro.parameters.editorposition.bottom');
	const hiddenLabel = I18n.getText('de.scandio.diary.macro.parameters.editorposition.hidden');

	$editorPositionParamContainer.find('option[value=top]').text(topLabel);
	$editorPositionParamContainer.find('option[value=bottom]').text(bottomLabel);
	$editorPositionParamContainer.find('option[value=hidden]').text(hiddenLabel);
}

export function renderStyleI18n() {
	const $diaryStyleParameterContainer = $('#macro-param-div-style');
	const simpleLabel = I18n.getText('de.scandio.diary.macro.parameters.style.simple');
	const bubbleLabel = I18n.getText('de.scandio.diary.macro.parameters.style.bubble');

	$diaryStyleParameterContainer.find('option[value=simple]').text(simpleLabel);
	$diaryStyleParameterContainer.find('option[value=bubble]').text(bubbleLabel);
}

const optionTemplate = (value, name) => `<option value="${value}">${name}</option>`;

export function renderTemplateIdInput(params) {
	const $templateId = $('#macro-param-div-templateid');
	const $select = $templateId.find('select').disable();
	const templateId = params.templateid;
	const globalTemplatePrefix = '[' + I18n.getText('de.scandio.diary.macro.parameters.templateid.global-prefix') + '] ';
	const noTemplateLabel = '<' + I18n.getText('de.scandio.diary.macro.parameters.templateid.no-template') + '>';

	$templateId.find('label').append('<span class="scd-spinner aui-icon aui-icon-small aui-icon-wait"></span>');

	$select.find('option').first().text(noTemplateLabel);

	getTemplates(templates => {
		templates.space.results.forEach(template => {
			if (template.templateType === 'page') {
				$select.append(optionTemplate(template.templateId, template.name));
			}
		});

		templates.global.results.forEach(template => {
			if (template.templateType === 'page') {
				$select.append(optionTemplate(template.templateId, globalTemplatePrefix + template.name));
			}
		});

		templateId && $select.val(templateId);
		$templateId.find('.scd-spinner').remove();
		$select.enable();
	}, error => {
		showCantLoadTemplates(error);
		templateId && $select.val(templateId);
		$templateId.find('.scd-spinner').remove();
	});
}