/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.macro;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.scandio.atlassian.licensing.confluence.macro.LicensedMacro;
import de.scandio.confluence.plugins.diary.html.DiaryRenderer;
import de.scandio.confluence.plugins.diary.util.ResourceUtil;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

public class DiaryMacro
extends LicensedMacro {
    private final PageBuilderService pageBuilderService;
    private final PageTemplateManager pageTemplateManager;
    private final FormatConverter formatConverter;
    private final AccessModeService accessModeService;

    @Autowired
    public DiaryMacro(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport FormatConverter formatConverter, @ComponentImport AccessModeService accessModeService) {
        this.pageBuilderService = pageBuilderService;
        this.pageTemplateManager = pageTemplateManager;
        this.formatConverter = formatConverter;
        this.accessModeService = accessModeService;
        this.setPluginLicenseManager(pluginLicenseManager);
        this.setPluginAccessor(pluginAccessor);
    }

    @Override
    protected String getProductName() {
        return "Diary for Confluence";
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if ("pdf".equalsIgnoreCase(conversionContext.getOutputType())) {
            return this.renderDiaryForPdf(parameters, body);
        }
        ResourceUtil.requireCorrectResources(this.pageBuilderService, parameters);
        parameters.put("read-only", String.valueOf(this.accessModeService.isReadOnlyAccessModeEnabled()));
        return new DiaryRenderer(parameters, body, conversionContext, this.pageTemplateManager, this.formatConverter).render();
    }

    private String renderDiaryForPdf(Map<String, String> parameters, String body) {
        String renderedDiary = "";
        Elements tables = Jsoup.parse(body).getElementsByTag("table");
        if (tables.size() > 0) {
            Element entriesTable = (Element)tables.get(0);
            Elements tableRows = entriesTable.getElementsByTag("tbody").first().children();
            tableRows.forEach(tableRow -> tableRow.children().last().remove());
            renderedDiary = entriesTable.toString();
        }
        return renderedDiary;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

