/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.sal.api.message.I18nResolver;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.ContentEntityUtils;
import de.scandio.confluence.plugins.diary.util.EntryPreview;
import de.scandio.confluence.plugins.diary.util.Permissions;
import de.scandio.confluence.plugins.diary.xml.XmlDiaryMacro;
import de.scandio.confluence.plugins.diary.xml.XmlParser;
import java.io.Serializable;
import java.util.Optional;

public class DeleteEntryAction {
    private static final String I18N_DELETED_DIARY_ENTRY = "de.scandio.diary.version-comment.deleted-entry";
    private static final String DIARY_NOT_FOUND_MSG = "Diary with id %s not found in version %d of page %d";
    private static final String MERGE_ERROR_MSG = "<p>This page was edited while trying to delete your entry. It was edited in such a way that your Diary was unable to merge the deletion of your entry into the new version of the page.</p><p>Please <a href=\"\" class=\"page-reloader\">reload the page</a> and try deleting the entry again.</p>";
    private final int version;
    private final int entryId;
    private final long contentId;
    private final String macroId;
    private final String contentType;
    private final I18nResolver i18nResolver;

    public DeleteEntryAction(int version, int entryId, long contentId, String macroId, String contentType, I18nResolver i18nResolver) {
        this.version = version;
        this.entryId = entryId;
        this.contentId = contentId;
        this.macroId = macroId;
        this.contentType = contentType;
        this.i18nResolver = i18nResolver;
    }

    public boolean execute() throws Exception {
        ContentEntityObject inCurrentVersion = ContentEntityUtils.getContentEntityOrThrow(this.contentId, this.contentType);
        ContentEntityObject inRequestedVersion = ContentEntityUtils.getContentEntityOrThrow(this.contentId, this.contentType, this.version);
        Permissions.throwIfCurrentUserCanNotEdit(inCurrentVersion);
        XmlParser xmlParser = new XmlParser(inRequestedVersion.getBodyAsString());
        Optional<XmlDiaryMacro> maybeDiary = xmlParser.getDiaryById(this.macroId);
        if (!maybeDiary.isPresent()) {
            String message = String.format(DIARY_NOT_FOUND_MSG, this.macroId, this.version, this.contentId);
            throw new ExceptionWithoutStacktrace(message);
        }
        String content = maybeDiary.get().deleteEntry(this.entryId);
        String versionComment = this.i18nResolver.getText(I18N_DELETED_DIARY_ENTRY, new Serializable[]{EntryPreview.getEntryPreview(content)});
        boolean wasMerged = ContentEntityUtils.saveOrMergeEditedContentEntity(inCurrentVersion, inRequestedVersion, xmlParser.toString(), versionComment, MERGE_ERROR_MSG);
        return wasMerged;
    }
}

