/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.atlassian.licensing.utils;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtils {
    private static final Logger log = LoggerFactory.getLogger(LicenseUtils.class);

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager, PluginAccessor pluginAccessor) {
        if (pluginLicenseManager == null) {
            log.warn("License check failed because pluginLicenseManager could not be retrieved. Skipping.");
            return true;
        }
        if (pluginAccessor == null) {
            log.warn("License check failed because pluginAccessor could not be retrieved. Skipping.");
            return true;
        }
        String pluginKey = pluginLicenseManager.getPluginKey();
        Plugin plugin = pluginAccessor.getPlugin(pluginKey);
        if (!LicenseUtils.isLicensingEnabled(plugin)) {
            return true;
        }
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)pluginLicenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    public static boolean isLicensingEnabled(Plugin plugin) {
        Map parameters = plugin.getPluginInformation().getParameters();
        return parameters != null && parameters.get("atlassian-licensing-enabled") != null && ((String)parameters.get("atlassian-licensing-enabled")).equals("true");
    }

    public static PluginLicense getLicense(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager == null) {
            log.warn("getLicense failed because PluginLicenseManager could not be retrieved.");
            return null;
        }
        return pluginLicenseManager.getLicense().isDefined() ? (PluginLicense)pluginLicenseManager.getLicense().get() : null;
    }

    public static String renderLicenseError(PluginLicenseManager pluginLicenseManager, String productName) {
        PluginLicense pluginLicense = LicenseUtils.getLicense(pluginLicenseManager);
        LicenseManager licenseManager = LicenseManager.getInstance();
        Map velocityContext = MacroUtils.defaultVelocityContext();
        velocityContext.put("productName", productName);
        if (pluginLicense == null) {
            velocityContext.put("errorType", "noLicense");
        } else if (pluginLicense.getError().isDefined()) {
            LicenseError licenseError = (LicenseError)pluginLicense.getError().get();
            if (LicenseError.EXPIRED.equals((Object)licenseError)) {
                velocityContext.put("errorType", "expired");
            } else if (LicenseError.TYPE_MISMATCH.equals((Object)licenseError)) {
                License license = licenseManager.getLicense("CONF");
                if (license != null) {
                    velocityContext.put("errorType", "typeMismatch");
                    velocityContext.put("licenseType", license.getLicenseType().getNiceName());
                } else {
                    velocityContext.put("errorType", "generic");
                }
            } else if (LicenseError.USER_MISMATCH.equals((Object)licenseError)) {
                License license = licenseManager.getLicense("CONF");
                if (license != null && pluginLicense.getMaximumNumberOfUsers().isDefined()) {
                    velocityContext.put("errorType", "userMismatch");
                    velocityContext.put("pluginLicenseUserLimit", pluginLicense.getMaximumNumberOfUsers().get());
                    velocityContext.put("licenseUserLimit", license.getUsers());
                } else {
                    velocityContext.put("errorType", "generic");
                }
            } else if (LicenseError.VERSION_MISMATCH.equals((Object)licenseError)) {
                velocityContext.put("errorType", "versionMismatch");
                velocityContext.put("version", GeneralUtil.getVersionNumber());
            } else {
                velocityContext.put("errorType", "generic");
            }
        } else {
            throw new RuntimeException("No error to render");
        }
        return VelocityUtils.getRenderedTemplate((String)"de/scandio/atlassian/licensing/templates/license-error.vm", (Map)velocityContext);
    }
}

