/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.atlassian.licensing.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.scandio.atlassian.licensing.Config;
import de.scandio.atlassian.licensing.utils.LicenseUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LicensedMacro
extends BaseMacro
implements Macro {
    @Autowired
    private PluginLicenseManager pluginLicenseManager;
    @Autowired
    private PluginAccessor pluginAccessor;

    protected String getProductName() {
        return Config.getInstance().getProductName();
    }

    protected abstract String doExecute(Map<String, String> var1, String var2, ConversionContext var3) throws MacroExecutionException;

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        if (LicenseUtils.isLicensed(this.pluginLicenseManager, this.pluginAccessor)) {
            return this.doExecute(parameters, body, context);
        }
        return LicenseUtils.renderLicenseError(this.pluginLicenseManager, this.getProductName());
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)parameters, body, (ConversionContext)new DefaultConversionContext(renderContext));
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }

    public boolean hasBody() {
        return !Macro.BodyType.NONE.equals((Object)this.getBodyType());
    }

    public RenderMode getBodyRenderMode() {
        return Macro.OutputType.INLINE.equals((Object)this.getOutputType()) ? RenderMode.INLINE : (Macro.BodyType.RICH_TEXT.equals((Object)this.getBodyType()) ? RenderMode.ALL : RenderMode.NO_RENDER);
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

