/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/main/resources/diary/js/macrobrowser.js":
/*!*****************************************************!*\
  !*** ./src/main/resources/diary/js/macrobrowser.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./macrobrowser/parameters */ "./src/main/resources/diary/js/macrobrowser/parameters.js");
/* global AJS */


function beforeParamsSet(params) {
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.renderOrderI18n)();
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.renderEditorPositionI18n)();
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.renderStyleI18n)();
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.initTimeParameterClickListener)(params);
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.initTitleParameterClickListener)(params);
  (0,_macrobrowser_parameters__WEBPACK_IMPORTED_MODULE_0__.renderTemplateIdInput)(params);
  return params;
}

AJS.I18n.get('de.scandio.confluence.plugins.diary', function () {
  AJS.toInit(function () {
    AJS.MacroBrowser && AJS.MacroBrowser.setMacroJsOverride('diary', {
      beforeParamsSet: beforeParamsSet
    });
  });
});

/***/ }),

/***/ "./src/main/resources/diary/js/macrobrowser/parameters.js":
/*!****************************************************************!*\
  !*** ./src/main/resources/diary/js/macrobrowser/parameters.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "initTimeParameterClickListener": function() { return /* binding */ initTimeParameterClickListener; },
/* harmony export */   "initTitleParameterClickListener": function() { return /* binding */ initTitleParameterClickListener; },
/* harmony export */   "renderOrderI18n": function() { return /* binding */ renderOrderI18n; },
/* harmony export */   "renderEditorPositionI18n": function() { return /* binding */ renderEditorPositionI18n; },
/* harmony export */   "renderStyleI18n": function() { return /* binding */ renderStyleI18n; },
/* harmony export */   "renderTemplateIdInput": function() { return /* binding */ renderTemplateIdInput; }
/* harmony export */ });
/* harmony import */ var _util_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/environment */ "./src/main/resources/diary/js/util/environment.js");
/* harmony import */ var _rest_getTemplates__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../rest/getTemplates */ "./src/main/resources/diary/js/rest/getTemplates.js");
/* harmony import */ var _util_flags_macrobrowserFlags__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/flags/macrobrowserFlags */ "./src/main/resources/diary/js/util/flags/macrobrowserFlags.js");




function initToggleableParameter($checkbox, $inputToToggle, hideInitially) {
  if (hideInitially) {
    $inputToToggle.hide();
  }

  $checkbox.on('click', function () {
    if ($checkbox.attr('checked')) {
      $inputToToggle.show();
    } else {
      $inputToToggle.hide();
    }
  });
}

function initTimeParameterClickListener(params) {
  var $checkbox = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-time input');
  var $timeFormatInput = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-timeformat');
  var hideInitially = params.time === 'false';
  initToggleableParameter($checkbox, $timeFormatInput, hideInitially);
}
function initTitleParameterClickListener(params) {
  var $titleTextInput = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-title');
  var $checkbox = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-showtitle input');
  var hideInitially = !params.showtitle;
  initToggleableParameter($checkbox, $titleTextInput, hideInitially);
}
function renderOrderI18n() {
  var $orderParamContainer = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-order');
  var descLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.order.descending');
  var ascLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.order.ascending');
  $orderParamContainer.find('option[value=descending]').text(descLabel);
  $orderParamContainer.find('option[value=ascending]').text(ascLabel);
}
function renderEditorPositionI18n() {
  var $editorPositionParamContainer = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-editorposition');
  var topLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.editorposition.top');
  var bottomLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.editorposition.bottom');
  var hiddenLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.editorposition.hidden');
  $editorPositionParamContainer.find('option[value=top]').text(topLabel);
  $editorPositionParamContainer.find('option[value=bottom]').text(bottomLabel);
  $editorPositionParamContainer.find('option[value=hidden]').text(hiddenLabel);
}
function renderStyleI18n() {
  var $diaryStyleParameterContainer = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-style');
  var simpleLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.style.simple');
  var bubbleLabel = _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.style.bubble');
  $diaryStyleParameterContainer.find('option[value=simple]').text(simpleLabel);
  $diaryStyleParameterContainer.find('option[value=bubble]').text(bubbleLabel);
}

var optionTemplate = function optionTemplate(value, name) {
  return "<option value=\"".concat(value, "\">").concat(name, "</option>");
};

function renderTemplateIdInput(params) {
  var $templateId = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)('#macro-param-div-templateid');
  var $select = $templateId.find('select').disable();
  var templateId = params.templateid;
  var globalTemplatePrefix = '[' + _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.templateid.global-prefix') + '] ';
  var noTemplateLabel = '<' + _util_environment__WEBPACK_IMPORTED_MODULE_0__.I18n.getText('de.scandio.diary.macro.parameters.templateid.no-template') + '>';
  $templateId.find('label').append('<span class="scd-spinner aui-icon aui-icon-small aui-icon-wait"></span>');
  $select.find('option').first().text(noTemplateLabel);
  (0,_rest_getTemplates__WEBPACK_IMPORTED_MODULE_1__.getTemplates)(function (templates) {
    templates.space.results.forEach(function (template) {
      if (template.templateType === 'page') {
        $select.append(optionTemplate(template.templateId, template.name));
      }
    });
    templates.global.results.forEach(function (template) {
      if (template.templateType === 'page') {
        $select.append(optionTemplate(template.templateId, globalTemplatePrefix + template.name));
      }
    });
    templateId && $select.val(templateId);
    $templateId.find('.scd-spinner').remove();
    $select.enable();
  }, function (error) {
    (0,_util_flags_macrobrowserFlags__WEBPACK_IMPORTED_MODULE_2__.showCantLoadTemplates)(error);
    templateId && $select.val(templateId);
    $templateId.find('.scd-spinner').remove();
  });
}

/***/ }),

/***/ "./src/main/resources/diary/js/rest/ajax.js":
/*!**************************************************!*\
  !*** ./src/main/resources/diary/js/rest/ajax.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ajax": function() { return /* binding */ ajax; }
/* harmony export */ });
/* harmony import */ var _util_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/environment */ "./src/main/resources/diary/js/util/environment.js");

function ajax(options, successCallback, errorCallback) {
  _util_environment__WEBPACK_IMPORTED_MODULE_0__.$.ajax(options).done(function (data) {
    successCallback(data);
  }).fail(function (jqXHR) {
    if (jqXHR.message) {
      errorCallback(jqXHR.message);
    } else {
      var exceptionMessage = (0,_util_environment__WEBPACK_IMPORTED_MODULE_0__.$)(jqXHR.responseXML).find('message').text();
      errorCallback(exceptionMessage ? exceptionMessage : jqXHR.statusText);
    }
  });
}

/***/ }),

/***/ "./src/main/resources/diary/js/rest/getTemplates.js":
/*!**********************************************************!*\
  !*** ./src/main/resources/diary/js/rest/getTemplates.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getTemplates": function() { return /* binding */ getTemplates; }
/* harmony export */ });
/* harmony import */ var _util_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/environment */ "./src/main/resources/diary/js/util/environment.js");
/* harmony import */ var _ajax__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ajax */ "./src/main/resources/diary/js/rest/ajax.js");


function getTemplates(successCallback, errorCallback) {
  (0,_ajax__WEBPACK_IMPORTED_MODULE_1__.ajax)({
    url: _util_environment__WEBPACK_IMPORTED_MODULE_0__.restEndpoints.getTemplates + '&spaceKey=' + _util_environment__WEBPACK_IMPORTED_MODULE_0__.spaceKey,
    type: 'GET'
  }, function (spaceTemplates) {
    (0,_ajax__WEBPACK_IMPORTED_MODULE_1__.ajax)({
      url: _util_environment__WEBPACK_IMPORTED_MODULE_0__.restEndpoints.getTemplates,
      type: 'GET'
    }, function (globalTemplates) {
      successCallback({
        space: spaceTemplates,
        global: globalTemplates
      });
    }, errorCallback);
  }, errorCallback);
}

/***/ }),

/***/ "./src/main/resources/diary/js/util/environment.js":
/*!*********************************************************!*\
  !*** ./src/main/resources/diary/js/util/environment.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$": function() { return /* binding */ $; },
/* harmony export */   "ready": function() { return /* binding */ ready; },
/* harmony export */   "flag": function() { return /* binding */ flag; },
/* harmony export */   "I18n": function() { return /* binding */ I18n; },
/* harmony export */   "contextPath": function() { return /* binding */ contextPath; },
/* harmony export */   "pageTitle": function() { return /* binding */ pageTitle; },
/* harmony export */   "dateFormat": function() { return /* binding */ dateFormat; },
/* harmony export */   "spaceKey": function() { return /* binding */ spaceKey; },
/* harmony export */   "contentType": function() { return /* binding */ contentType; },
/* harmony export */   "currentUser": function() { return /* binding */ currentUser; },
/* harmony export */   "restEndpoints": function() { return /* binding */ restEndpoints; }
/* harmony export */ });
/* global AJS */
var $ = AJS.$;
var ready = AJS.toInit;
var flag = AJS.flag;
var I18n = AJS.I18n;
var contextPath = AJS.Meta.get('context-path');
var pageTitle = AJS.Meta.get('page-title');
var dateFormat = AJS.Meta.get('date.format').toUpperCase();
var spaceKey = AJS.Meta.get('space-key');
var contentType = AJS.Meta.get('content-type');
var currentUser = {
  avatarURL: AJS.Meta.get('current-user-avatar-uri-reference'),
  displayName: AJS.Meta.get('user-display-name'),
  userName: AJS.Meta.get('remote-user'),
  userKey: AJS.Meta.get('remote-user-key')
};
var restEndpoints = {
  getUser: contextPath + '/rest/api/user?username=',
  getCurrentUser: contextPath + '/rest/api/user/current',
  saveEntry: contextPath + '/rest/diary/1.0/entry/save',
  editEntry: contextPath + '/rest/diary/1.0/entry/edit',
  deleteEntry: contextPath + '/rest/diary/1.0/entry/delete',
  getTemplates: contextPath + '/rest/experimental/template/page?limit=200',
  getEditorFormat: function getEditorFormat(contentId, version, macroId, entryId) {
    return "".concat(contextPath, "/rest/diary/1.0/entry/editorformat?contentid=").concat(contentId, "&version=").concat(version, "&macroid=").concat(macroId, "&entryid=").concat(entryId, "&type=").concat(contentType);
  }
};

/***/ }),

/***/ "./src/main/resources/diary/js/util/flags/macrobrowserFlags.js":
/*!*********************************************************************!*\
  !*** ./src/main/resources/diary/js/util/flags/macrobrowserFlags.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "showCantLoadTemplates": function() { return /* binding */ showCantLoadTemplates; }
/* harmony export */ });
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../environment */ "./src/main/resources/diary/js/util/environment.js");

function showCantLoadTemplates(error) {
  (0,_environment__WEBPACK_IMPORTED_MODULE_0__.flag)({
    type: 'error',
    title: 'There was an error loading your page templates.',
    // TODO I18n
    body: error
  });
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	// startup
/******/ 	// Load entry module
/******/ 	__webpack_require__("./src/main/resources/diary/js/macrobrowser.js");
/******/ 	// This entry module used 'exports' so it can't be inlined
/******/ })()
;
//# sourceMappingURL=macrobrowser.js.map