
import {flag} from '../environment';

function showErrorWhileSavingFlag(options) {
	flag(options);
	AJS.Confluence.Editor.UI.toggleSavebarBusy(false);
}

export function showRestBadStatusFlag(response) {
	showErrorWhileSavingFlag({
		type: 'error',
		title: 'Could not save entry.',
		body: response.message
	});
}

export function showRestInvalidResponseFlag(error) {
	showErrorWhileSavingFlag({
		type: 'error',
		title: 'Invalid response from diary REST endpoint.',
		body: 'The diary REST endpoint for saving entries did not respond with code 2xx.' +
			'<p>' + error + '</p>'
	});
}

export function showCantSaveEmptyEntryFlag() {
	showErrorWhileSavingFlag({
		type: 'error',
		title: 'Can\'t save empty entry.',
		body: 'Empty entries can\'t be saved.'
	});
}
