import {restEndpoints} from '../util/environment';
import {ajax} from './ajax';

const userInfoCache = [];
const callbackQueues = [];

export function getUser(userName, callback) {
	if (userName) {

		let foundUnfetchedUserInfo = false;
		callbackQueues.forEach(function(currentQueue) {
			if (currentQueue.userName === userName) {
				currentQueue.callbackQueue.push(callback);
				foundUnfetchedUserInfo = true;
			}
		});

		if (!foundUnfetchedUserInfo) {
			const maybeCachedUserInfo = getCachedUserInfo(userName);

			if (maybeCachedUserInfo) {
				callback(maybeCachedUserInfo);
			} else {
				callbackQueues.push({userName: userName, callbackQueue: []});

				ajax({
					type: 'GET',
					url: restEndpoints.getUser + userName,
					ifModified: true
				}, data => {
					let result = {};
					result.userName = userName;
					result.userKey = data && data.userKey ? data.userKey : undefined;
					result.displayName = data && data.displayName ? data.displayName : undefined;
					result.avatarURL = data && data.profilePicture && data.profilePicture.path ? data.profilePicture.path : undefined;

					userInfoCache.unshift(result);
					completeCallbackQueue(userName, result);
					callback(result);
				}, () => {
					callback(undefined);
				});
			}
		}
	} else {
		callback(undefined);
	}
}

function getCachedUserInfo(userName) {
	let maybeCachedUserInfo = undefined;

	userInfoCache.forEach(function(cachedItem) {
		if (!maybeCachedUserInfo && cachedItem.userName === userName) {
			maybeCachedUserInfo = cachedItem;
		}
	});

	return maybeCachedUserInfo;
}

function completeCallbackQueue(userName, fetchedInformation) {
	callbackQueues.forEach(function(item, index) {
		if (item.userName === userName) {
			item.userName = undefined; // keep new callers from adding their callback. (faster than splice)

			item.callbackQueue.forEach(function(waitingCallback) {
				waitingCallback(fetchedInformation);
			});

			callbackQueues.splice(index, 1);
		}
	});
}