import {editEntry} from '../../../rest/editEntry';
import {showCantSaveEmptyEntryFlag,} from '../../../util/flags/saveNewEntryFlags';
import {showEditEntryInvalidResponse, showUnableToSaveEditedEntry} from '../../../util/flags/editEntryFlags';

export function createEditEntrySaveHandler($entry, diary, entryId) {
	return function() {
		const content = AJS.Rte.getEditor() && AJS.Rte.getEditor().getContent();

		if (content && content !== '<p><br /></p>') {
			const editEntryOptions = {
				version: $entry.attr('data-page-version') || diary.dataset.pageVersion,
				contentid: diary.dataset.pageId,
				macroid: diary.id,
				entryid: entryId,
				content: content
			};

			editEntry(editEntryOptions, response => {
				if (response.status === 'success') {
					window.location.hash = '#' + diary.id + '+' + entryId;
					location.reload();
				} else {
					showUnableToSaveEditedEntry(response.message);
				}
			}, showEditEntryInvalidResponse);
		} else {
			showCantSaveEmptyEntryFlag();
		}
	};
}
