import {contextPath, currentUser, I18n} from '../../util/environment';

export const BUBBLE_EDITOR_TEMPLATE = () => `
  <div class="entry-editor editor-bubble">
  
    <div class="quick-comment-container comment add">
      <div class="image-column">
        <a data-username="${currentUser.userName}" href="${contextPath}/display/~${currentUser.userName}" title="">
          <img class="user-logo" src="${currentUser.avatarURL}" />
        </a>
      </div>
    
      <div class="quick-comment-body">
        <div class="loading-container">
          <span class="scd-spinner aui-icon aui-icon-small aui-icon-wait">
            ${I18n.getText('de.scandio.diary.macro.entry.loading')}
          </span>
        </div>
        
        <div class="ic-sidebar"> <!-- needed for conf 6.7+ user mentions -->
          <form style="display:block;" class="quick-comment-form aui">
            <div title="Add an entry" class="quick-editor-prompt"><span>
              ${I18n.getText('de.scandio.diary.macro.editor.new-entry-msg')}
            </span></div>
          </form>
        </div>
    
      </div>
    </div>
  </div>
`;