/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.mentions.api.ConfluenceMentionEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import de.scandio.confluence.plugins.diary.dto.DiaryMentionUserProfileDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotificationsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailNotificationsUtil.class);
    private static EventPublisher eventPublisher;

    private static EventPublisher getEventPublisher() {
        if (eventPublisher == null) {
            eventPublisher = (EventPublisher)ComponentLocator.getComponent(EventPublisher.class);
        }
        return eventPublisher;
    }

    public static void fireMentionEvent(ConfluenceUser creator, ConfluenceUser recipient, ContentEntityObject contentEntityObject, String entry) {
        try {
            DiaryMentionUserProfileDto userProfile = new DiaryMentionUserProfileDto(recipient.getKey(), recipient.getName(), recipient.getFullName(), recipient.getEmail());
            ConfluenceMentionEvent event = new ConfluenceMentionEvent((Object)contentEntityObject.getTitle(), contentEntityObject, (UserProfile)userProfile, creator, entry);
            EmailNotificationsUtil.getEventPublisher().publish((Object)event);
        }
        catch (Exception e) {
            LOGGER.warn("Email for {}, informing the user about mention in Diary, could not be sent.", (Object)recipient.getName(), (Object)e);
        }
    }
}

