/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.actions;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import de.scandio.confluence.plugins.diary.actions.SaveNewEntryActionResult;
import de.scandio.confluence.plugins.diary.exception.ExceptionWithoutStacktrace;
import de.scandio.confluence.plugins.diary.util.ContentEntityUtils;
import de.scandio.confluence.plugins.diary.util.DateTime;
import de.scandio.confluence.plugins.diary.util.EmailNotificationsUtil;
import de.scandio.confluence.plugins.diary.util.EntryPreview;
import de.scandio.confluence.plugins.diary.util.Permissions;
import de.scandio.confluence.plugins.diary.xml.XmlDiaryMacro;
import de.scandio.confluence.plugins.diary.xml.XmlEntry;
import de.scandio.confluence.plugins.diary.xml.XmlParser;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveNewEntryAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveNewEntryAction.class);
    private static final Pattern PATTERN = Pattern.compile("<ri:user ri:userkey=\\\"([^\\\"]*)\\\" />");
    private final long contentId;
    private final String content;
    private final String macroId;
    private final String userKey;
    private final String contentType;
    private final FormatConverter formatConverter;
    private final I18nResolver i18nResolver;
    private final UserAccessor userAccessor;

    public SaveNewEntryAction(long contentId, String content, String macroId, String userKey, String contentType, FormatConverter formatConverter, I18nResolver i18nResolver, UserAccessor userAccessor) {
        this.contentId = contentId;
        this.content = content;
        this.macroId = macroId;
        this.userKey = userKey;
        this.contentType = contentType;
        this.formatConverter = formatConverter;
        this.i18nResolver = i18nResolver;
        this.userAccessor = userAccessor;
    }

    public SaveNewEntryActionResult execute() throws Exception {
        ContentEntityObject contentEntity = ContentEntityUtils.getContentEntityOrThrow(this.contentId, this.contentType);
        Permissions.throwIfCurrentUserCanNotEdit(contentEntity);
        PageContext pageContext = contentEntity.toPageContext();
        String xml = this.formatConverter.convertToStorageFormat(this.content, (RenderContext)pageContext);
        String renderedHtml = this.formatConverter.convertToViewFormat(xml, (RenderContext)pageContext);
        XmlParser xmlParser = new XmlParser(contentEntity.getBodyAsString());
        Optional<XmlDiaryMacro> diaryOptional = xmlParser.getDiaryById(this.macroId);
        if (!diaryOptional.isPresent()) {
            String message = "Could not find diary with id: " + this.macroId;
            throw new ExceptionWithoutStacktrace(message);
        }
        XmlEntry newEntry = this.createNewEntry(this.userKey, xml);
        long entryIndex = diaryOptional.get().addEntry(newEntry);
        String versionComment = this.i18nResolver.getText("de.scandio.diary.version-comment.new-entry", new Serializable[]{EntryPreview.getEntryPreview(renderedHtml)});
        ContentEntityUtils.saveEditedContentEntity(contentEntity, xmlParser.toString(), versionComment);
        this.sendEmailToMentionedUsers(xml, renderedHtml);
        return new SaveNewEntryActionResult(xml, renderedHtml, entryIndex, contentEntity.getVersion());
    }

    private void sendEmailToMentionedUsers(String xml, String html) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Matcher matcher = PATTERN.matcher(xml);
        while (matcher.find()) {
            String userKeyString = matcher.group(1);
            if (userKeyString.equals(currentUser.getKey().getStringValue())) continue;
            UserKey userKey = new UserKey(userKeyString);
            Optional<ConfluenceUser> confluenceUserOptional = Optional.ofNullable(this.userAccessor.getUserByKey(userKey));
            confluenceUserOptional.ifPresent(user -> this.constructReminderForUser((ConfluenceUser)user, html));
        }
    }

    private void constructReminderForUser(ConfluenceUser remindedUser, String entry) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String remindedUserKey = remindedUser.getKey().getStringValue();
        try {
            ContentEntityObject contentEntityObject = ContentEntityUtils.getContentEntityOrThrow(this.contentId, this.contentType);
            Matcher matcher = PATTERN.matcher(contentEntityObject.getBodyContent().getBody());
            int matches = 0;
            while (matcher.find()) {
                if (!matcher.group(1).equals(remindedUserKey) || ++matches != 2) continue;
                EmailNotificationsUtil.fireMentionEvent(confluenceUser, remindedUser, contentEntityObject, entry);
                break;
            }
        }
        catch (ExceptionWithoutStacktrace exceptionWithoutStacktrace) {
            LOGGER.error("Could not obtain context for {}.", (Object)this.contentId);
        }
    }

    private XmlEntry createNewEntry(String userKey, String xml) {
        String currentTime = DateTime.getCurrentTime();
        String currentDate = DateTime.getCurrentDate();
        return new XmlEntry(userKey, currentDate, currentTime, xml);
    }
}

