
import {$, flag} from '../environment';

function showErrorWhileEditingFlag(options) {
	flag(options);
	AJS.Confluence.Editor.UI.toggleSavebarBusy(false);
}

export function showEditEntryInvalidResponse(error) {
	showErrorWhileEditingFlag({
		type: 'error',
		title: 'Edited entry could not be saved (response code not 200).',
		body: error
	});
}

export function showUnableToSaveEditedEntry(error) {
	const errorFlag = showErrorWhileEditingFlag({
		type: 'error',
		title: 'Could not save edited entry.',
		body: error && error.message ? error.message : error
	});

	$(errorFlag).find('.page-reloader').click(e => {
		e.preventDefault();
		location.reload();
	});
}
