
import {createEditor} from './editor/editor';
import {$} from '../../util/environment';
import {showCouldNotRenderEditButtonsFlag} from '../../util/flags/editButtonFlags';
import {createNewEntrySaveHandler} from './editor/newEntrySaveHandler';
import {renderEntryMenu} from './entryMenu';
import {
	getEditorUiTemplate,
	getEntryContentTemplate,
	hasEntryContentTemplate,
	userHasEditPermission
} from '../dom-diary-util';

export function renderUserInterface(diary) {
	renderEditor(diary);
	renderEntryButtons(diary);
}

function renderEditor(diary) {
	const editorPosition = diary.dataset.editorPosition;
	const editorHtml = getEditorUiTemplate(diary)();
	const $diary = $(diary);

	if (userHasEditPermission(diary)
		&& diary.dataset.pageId
		&& diary.dataset.pageVersion
		&& editorPosition !== 'hidden') {

		if (editorPosition === 'top') {
			const header = diary.querySelector('.header');

			if (header) {
				$(header).after(editorHtml);
			} else {
				$diary.prepend(editorHtml);
			}

		} else {
			$diary.append(editorHtml);
		}

		const editorOptions = {
			saveHandler: createNewEntrySaveHandler(diary),
			quickCommentPrompt: $diary.find('.quick-editor-prompt').first(),
			quickCommentForm: $diary.find('.quick-comment-form').first(),
			quickCommentContainer: $diary.find('.quick-comment-container').first(),
			postInitialise: () => {
				$diary.find('#rte-button-tasklist').remove();

				if (hasEntryContentTemplate(diary)) {
					const openEditor = AJS.Rte && AJS.Rte.getEditor();
					openEditor.setContent(getEntryContentTemplate(diary));
					openEditor.setDirty(false);
				}
			}
		};

		createEditor(diary, editorOptions).activateClickListener();
	}
}

function renderEntryButtons(diary) {
	const pageId = diary.dataset.pageId;
	const pageVersion = diary.dataset.pageVersion;

	if (pageId && pageVersion) {
		if (userHasEditPermission(diary)) {
			const entries = diary.querySelectorAll('.entries .entry');
			for (let i = 0; i < entries.length; i++) {
				renderEntryMenu($(entries[i]), diary);
			}
		}
	} else {
		showCouldNotRenderEditButtonsFlag(pageId, pageVersion);
	}
}
