import {activateAnchorLinkHandler} from './util/anchorlinks';
import {$, ready} from './util/environment';
import {hasParentWithClass} from './util/dom-utils';
import {renderDiary} from './render/diaryRenderer';

import '../scss/main.scss';

AJS.I18n.get('de.scandio.confluence.plugins.diary', function() {
	ready(function diaryMain() {
		fixPageEditButton();
		createDiaryShortCut();
		activateAnchorLinkHandler();
		bindEntryEditorHideListener();
		renderDiaries();
	});
});

function renderDiaries() {
	const diaries = document.getElementsByClassName('sc-diary');

	for (let i = 0; i < diaries.length; i++) {
		const diary = diaries[i];

		// TODO this once was a check for nested diaries but this is actually bs i think
		if (!hasParentWithClass(diary, 'macro-body')) {

			renderDiary(diary).then(function() {
				AJS.trigger('diary.rendered', diary.id);
				AJS.trigger('diary.' + diary.id + '.rendered');
			}).catch(function(error) {
				AJS.error('Error while rendering diary:', error);
				// TODO: show error message
			});
		}
	}
}

function createDiaryShortCut() {
	AJS.whenIType('d').moveToAndClick('.quick-editor-prompt');
}

function fixPageEditButton() {
	const $editAnchor = $('#editPageLink');
	$editAnchor.addClass('full-load');
	$editAnchor.unbind();
	AJS.whenIType('e').moveToAndClick($editAnchor);
}

function bindEntryEditorHideListener() {
	AJS.bind('quickedit.success', entryEditorHider);
	AJS.bind('rte-quick-comment-loading-failed', entryEditorHider);
}

function entryEditorHider() {
	$('.entry.being-edited').each((_, entry) => {
		const $entry = $(entry);

		if ($entry.find('#rte').length === 0) {
			$entry.find('.entry-editor').first().remove();
			$entry.find('.body').first().show();
			$entry.removeClass('being-edited');
		}
	});
}
