/*
 * Decompiled with CFR 0.152.
 */
package de.scandio.confluence.plugins.diary.html;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import de.scandio.confluence.plugins.diary.html.HtmlStringWrapper;
import de.scandio.confluence.plugins.diary.util.ConversionContextUtil;
import de.scandio.confluence.plugins.diary.util.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiaryRenderer {
    private final Map<String, Object> contextMap = new HashMap<String, Object>();
    private final List<HtmlStringWrapper> dataAttributes = new ArrayList<HtmlStringWrapper>();

    public DiaryRenderer(Map<String, String> parameters, String body, ConversionContext conversionContext, PageTemplateManager pageTemplateManager, FormatConverter formatConverter) {
        String macroID = ConversionContextUtil.getMacroID(conversionContext);
        this.contextMap.put("id", macroID == null ? "NO_MACRO_ID" : macroID);
        this.contextMap.put("macroBody", new HtmlStringWrapper(body));
        String templateId = parameters.get("templateid");
        String entryTemplate = ConversionContextUtil.getTemplateInEditorFormat(templateId, conversionContext, pageTemplateManager, formatConverter);
        this.contextMap.put("entryTemplate", new HtmlStringWrapper(entryTemplate));
        String title = parameters.get("title");
        if (title != null) {
            this.contextMap.put("title", title);
        }
        Boolean userHasPageEditPermission = macroID != null && Permissions.canCurrentUserEdit(conversionContext.getEntity());
        Boolean confluenceIsInReadOnlyMode = Boolean.valueOf(parameters.get("read-only"));
        Boolean diaryCanBeEdited = userHasPageEditPermission != false && confluenceIsInReadOnlyMode == false;
        this.addDataAttribute("order", parameters.get("order"), "descending").addDataAttribute("time", parameters.get("time"), "true").addDataAttribute("show-title", parameters.get("showtitle"), "false").addDataAttribute("editor-position", parameters.get("editorposition"), "top").addDataAttribute("style", parameters.get("style"), "simple").addDataAttribute("timeformat", parameters.get("timeformat"), "24h").addDataAttribute("can-edit", diaryCanBeEdited).addDataAttribute("page-id", ConversionContextUtil.getPageID(conversionContext)).addDataAttribute("page-version", ConversionContextUtil.getPageVersion(conversionContext)).addDataAttribute("use-template", parameters.get("usetemplate")).addDataAttribute("hide-welcome-message", parameters.get("hidewelcomemessage"), "false");
        this.contextMap.put("dataAttributes", this.dataAttributes);
    }

    public DiaryRenderer addDataAttribute(String key, Object value, Object fallbackValue) {
        if (value == null) {
            value = fallbackValue;
        }
        if (value != null) {
            this.dataAttributes.add(new HtmlStringWrapper("data-" + key + "=\"" + value + "\""));
        }
        return this;
    }

    public DiaryRenderer addDataAttribute(String key, Object value) {
        return this.addDataAttribute(key, value, null);
    }

    public String render() {
        return VelocityUtils.getRenderedTemplate((String)"/diary/templates/diary.vm", this.contextMap);
    }
}

