/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractOAuthConnector;
import de.resolution.usersync.spi.OAuthAuthorizationCodeConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthAuthorizationCodeConnector<T extends OAuthConnectorConfiguration>
extends AbstractOAuthConnector<T>
implements OAuthAuthorizationCodeConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthAuthorizationCodeConnector.class);
    public static final String RELATIVE_AUTHORIZE_URL = "/plugins/servlet/de.resolution.usersync/oauth2/authorize";

    protected AbstractOAuthAuthorizationCodeConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, T configuration, boolean newConnector, long lastUpdated, String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
    }

    public void requestAccessToken(@Nonnull String code) throws AccessTokenException {
        if (StringUtil.isNullOrEmpty(((OAuthConnectorConfiguration)this.configuration).getClientId()) || StringUtil.isNullOrEmpty(((OAuthConnectorConfiguration)this.configuration).getClientSecret())) {
            logger.error("Invalid configuration, cannot request access token.");
            throw new AccessTokenException("Invalid configuration. Client Id and/or Client secret are empty");
        }
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("grant_type", "authorization_code");
        formData.put("code", code);
        formData.put("client_id", ((OAuthConnectorConfiguration)this.configuration).getClientId());
        formData.put("client_secret", ((OAuthConnectorConfiguration)this.configuration).getClientSecret());
        formData.put("redirect_uri", this.connectorService.getBaseUrl() + RELATIVE_AUTHORIZE_URL);
        this.executeTokenRequest(formData);
    }

    @Override
    protected void refreshAccessToken() throws AccessTokenException {
        if (StringUtil.isNullOrEmpty(((OAuthConnectorConfiguration)this.configuration).getClientId()) || StringUtil.isNullOrEmpty(((OAuthConnectorConfiguration)this.configuration).getClientSecret())) {
            logger.error("Invalid configuration, cannot request access token.");
            throw new AccessTokenException("Invalid configuration. Client Id and/or Client secret are empty");
        }
        String refreshToken = this.getConnectorStorageValue("REFRESH_TOKEN").orElseThrow(() -> new AccessTokenException("Could not refresh access token because refresh token is missing."));
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("grant_type", "refresh_token");
        formData.put("client_id", ((OAuthConnectorConfiguration)this.configuration).getClientId());
        formData.put("client_secret", ((OAuthConnectorConfiguration)this.configuration).getClientSecret());
        formData.put("refresh_token", refreshToken);
        formData.put("redirect_uri", this.connectorService.getBaseUrl() + RELATIVE_AUTHORIZE_URL);
        this.getScope().ifPresent(scope -> formData.put("scope", scope));
        this.executeTokenRequest(formData);
    }

    @Override
    @Nullable
    public String getAuthorizationCodeUrl() {
        if (((OAuthConnectorConfiguration)this.configuration).getClientId() == null || ((OAuthConnectorConfiguration)this.configuration).getClientId().isEmpty()) {
            logger.debug("Client ID is not set yet, returning null");
            return null;
        }
        HttpUrl httpUrl = HttpUrl.parse(this.getAuthorizeUrl());
        if (httpUrl == null) {
            throw new NullPointerException("Parsing url returned null");
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder().addQueryParameter("client_id", ((OAuthConnectorConfiguration)this.configuration).getClientId()).addQueryParameter("redirect_uri", this.connectorService.getBaseUrl() + RELATIVE_AUTHORIZE_URL).addQueryParameter("access_type", "offline").addQueryParameter("state", this.getUniqueId()).addQueryParameter("response_type", "code").addQueryParameter("prompt", "consent");
        this.getScope().ifPresent(scope -> urlBuilder.addQueryParameter("scope", (String)scope));
        return urlBuilder.build().toString();
    }

    @Override
    public boolean isAuthorizationRequired() {
        return this.isStoredAccessTokenInvalid() && !this.getConnectorStorageValue("REFRESH_TOKEN").isPresent();
    }

    @Nonnull
    public abstract String getAuthorizeUrl();
}

