/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.onelogin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.onelogin.OneLoginConnector;
import de.resolution.usersync.builtin.onelogin.OneLoginConnectorConfiguration;
import de.resolution.usersync.builtin.onelogin.OneLoginConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractOAuthConnectorFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="OneLoginConnectorFactory")
@JsonAutoDetect
public class OneLoginConnectorFactory
extends AbstractOAuthConnectorFactory<OneLoginConnector, OneLoginConnectorConfiguration> {
    static final String NAME = "OneLogin";
    private static final String DESCRIPTION = "Connector using the OneLogin REST API";

    @Inject
    public OneLoginConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public OneLoginConnector create(@Nonnull OneLoginConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new OneLoginConnector(this.connectorService, this.atlasUserAdapter, configuration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public OneLoginConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        OneLoginConnectorConfigurationImpl mutableConfig = new OneLoginConnectorConfigurationImpl();
        mutableConfig.setName("new OneLogin");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public Class<OneLoginConnector> getConnectorClass() {
        return OneLoginConnector.class;
    }

    @Override
    @Nonnull
    public Class<OneLoginConnectorConfiguration> getConfigurationClass() {
        return OneLoginConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public String getSingleSyncInputDescription() {
        return "Please enter the username of the OneLogin user to update.";
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editOneLoginConnector.json";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull OneLoginConnectorConfiguration config) {
        ValidationResult result = super.validate(config);
        if (StringUtil.isNullOrEmpty(config.getBaseUrl())) {
            result.add("baseUrl", "Base URL must not be empty.", null);
        }
        return result;
    }

    @Override
    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        attributeTransformationConfigs.add(OneLoginConnectorConfigurationImpl.ACTIVE_TRANSFORMATION);
    }
}

