/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/uploadExcel")
public class UploadExcelFileRestResource {
    private static final Logger logger = LoggerFactory.getLogger(UploadExcelFileRestResource.class);
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;

    @Inject
    public UploadExcelFileRestResource(PrivilegeChecker privilegeChecker, ConnectorService connectorService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response uploadFile(@PathParam(value="id") String uniqueId, String jsonString, @Context HttpServletRequest request) throws IOException, InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        try {
            Object connector = this.connectorService.getConnectorByUniqueId(uniqueId).getConnector();
            Base64Holder base64Holder = JSONUtil.fromJson(jsonString, Base64Holder.class);
            String base64 = base64Holder.getBase64();
            if (base64 == null || base64.isEmpty()) {
                return Response.status((int)400).entity((Object)"Base64 is null or emtpy").build();
            }
            byte[] data = Base64.getDecoder().decode(base64);
            File file = File.createTempFile("usersync_excelimport", ".xlsx");
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
            }
            connector.setConnectorStorageValue("excelFile", file.getAbsolutePath());
            this.connectorService.reloadConnectorIntoCache(uniqueId);
            return Response.ok((Object)JSONUtil.asJson(new UploadResponse(file.getAbsolutePath()))).build();
        }
        catch (ConnectorNotFoundException e) {
            logger.warn("No connector found with id {}", (Object)uniqueId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException e) {
            logger.warn("Loading Connector failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    static class Base64Holder {
        private final String base64;

        @JsonCreator
        public Base64Holder(@JsonProperty(value="base64") String base64) {
            this.base64 = base64;
        }

        public String getBase64() {
            return this.base64;
        }
    }

    static class UploadResponse {
        public final String filepath;

        public UploadResponse(String filepath) {
            this.filepath = filepath;
        }
    }
}

