/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.regex.tester;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.regex.tester.RegexMatchTestResult;
import de.resolution.reconfigure.regex.tester.RegexNameValueId;
import de.resolution.reconfigure.regex.tester.RegexNameValueIdTestData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/regexnamevalueid")
public class RegexNameValueIdRestResource<C extends Configuration> {
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private static final Logger logger = LoggerFactory.getLogger(RegexNameValueIdRestResource.class);
    private static final int REGEX_TIMEOUT = 2000;
    private static final int NO_MATCHED_ID = -1;

    @Autowired
    public RegexNameValueIdRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
    }

    @PUT
    @Path(value="/checknamevalueid/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response check(@Nullable String testDataString, @Nullable @Context HttpServletRequest request, @Nullable @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        if (testDataString == null || testDataString.trim().isEmpty()) {
            logger.warn("Test data must not be null or empty");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CC_NO_CACHE).build();
        }
        if (request == null) {
            logger.warn("Request must not be null");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CC_NO_CACHE).build();
        }
        RegexNameValueIdTestData testData = JSONUtil.fromJson(testDataString, RegexNameValueIdTestData.class);
        if (testData.name != null) {
            testData.name = testData.name.trim().toLowerCase();
        }
        RegexMatchTestResult response = this.selectIdpByRequestHeader(Collections.singletonMap(testData.name, testData.value), testData.lines);
        logger.debug("Checking regex: {}, {}", (Object)response.matched, (Object)response.message);
        return Response.ok((Object)response).cacheControl(CC_NO_CACHE).build();
    }

    public RegexMatchTestResult selectIdpByRequestHeader(Map<String, String> headers, List<RegexNameValueId> headerValueIdpIds) {
        int id = -1;
        int arrayIndex = -1;
        boolean matched = false;
        String message = "No Match";
        int i = 0;
        for (RegexNameValueId current : headerValueIdpIds) {
            String currentRegex;
            if (current.name == null || current.name.trim().isEmpty() || !headers.containsKey(current.name.trim().toLowerCase())) {
                ++i;
                continue;
            }
            String headerValue = headers.get(current.name.toLowerCase());
            if (headerValue == null) {
                headerValue = "";
            }
            if ((currentRegex = current.value) == null) {
                currentRegex = "";
            }
            try {
                if (BoundedRegex.matches(currentRegex, headerValue, 2000L)) {
                    id = current.id;
                    matched = true;
                    message = "Match with Id: " + current.id;
                    arrayIndex = i;
                    logger.debug("Regex result: {}, {}", (Object)true, (Object)message);
                    return new RegexMatchTestResult(true, message, id, arrayIndex);
                }
            }
            catch (TimeoutExceededException | PatternSyntaxException e) {
                message = "Pattern Syntax Error:" + e.getMessage();
                id = -1;
                arrayIndex = -1;
            }
            ++i;
        }
        logger.debug("Regex result: {}, {}", (Object)matched, (Object)message);
        return new RegexMatchTestResult(matched, message, id, arrayIndex);
    }
}

