/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.directory;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import java.util.List;
import javax.annotation.Nonnull;

public interface DirectoryAdapter {
    @Nonnull
    public Long getFirstWritableDirectoryId();

    @Nonnull
    public AtlasUserDirectory create(AtlasUserDirectory var1) throws DirectoryNameExistsAlreadyException;

    @Nonnull
    public AtlasUserDirectory update(AtlasUserDirectory var1) throws DirectoryNotFoundException, InvalidOperationException, DirectoryNameExistsAlreadyException;

    public void delete(long var1) throws InvalidOperationException, DirectoryNotFoundException, AtlasUserOperationFailedException;

    @Nonnull
    public List<AtlasUserDirectory> getDirectories();

    public AtlasUserDirectory get(long var1);

    public List<AtlasUserDirectory> get(String var1);

    public boolean exists(@Nonnull String var1);

    @Nonnull
    public List<AtlasUserDirectory> getAtlasUserDirectories();

    @Nonnull
    public List<AtlasUserDirectory> getWritableDirectories();

    public boolean exists(long var1);

    public boolean isApplicable(long var1);

    public boolean isWritable(long var1);

    public boolean isActive(long var1);

    public void setPosition(long var1, int var3);

    public int getPosition(long var1);

    public long getLowestDirectoryId();

    public boolean isAtlasUser(long var1);

    public boolean isUseNestedGroups(long var1);
}

