/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import de.resolution.usersync.spi.OAuthConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import groovy.lang.Script;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthConnector<T extends OAuthConnectorConfiguration>
extends AbstractHTTPConnector<T>
implements OAuthConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthConnector.class);
    private static final Script OAUTH_RESPONSE_KEY_ACCESS_TOKEN_EXPRESSION = StructuredData.prepareFind("access_token");
    private static final Script OAUTH_RESPONSE_KEY_REFRESH_TOKEN_EXPRESSION = StructuredData.prepareFind("refresh_token");
    private static final Script OAUTH_RESPONSE_KEY_EXPIRES_IN_EXPRESSION = StructuredData.prepareFind("expires_in");

    AbstractOAuthConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, T configuration, boolean newConnector, long lastUpdated, String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
    }

    @Nullable
    protected abstract String getTokenUrl();

    @Nonnull
    protected abstract Optional<String> getScope();

    protected abstract void refreshAccessToken() throws AccessTokenException;

    protected void refreshAccessTokenIfInvalid() throws AccessTokenException {
        if (this.isStoredAccessTokenInvalid()) {
            this.refreshAccessToken();
        }
    }

    @Override
    protected boolean reauthenticateConnector() {
        try {
            this.refreshAccessToken();
            return true;
        }
        catch (AccessTokenException e) {
            logger.error("Refreshing the access token failed", (Throwable)e);
            return false;
        }
    }

    protected void executeTokenRequest(@Nonnull Map<Object, Object> formFields) throws AccessTokenException {
        String tokenUrl = this.getTokenUrl();
        logger.debug("Requesting new Access Token from {}", (Object)tokenUrl);
        if (tokenUrl == null) {
            throw new AccessTokenException("Invalid configuration. Token URL must not be empty");
        }
        ResponseWrapper responseWrapper = this.httpWrapper.postAsForm(tokenUrl, formFields);
        if (!responseWrapper.isSuccess()) {
            throw new AccessTokenException(responseWrapper.getCode(), "Unexpected response while fetching token: " + responseWrapper.getCode() + ": " + responseWrapper.getMessage() + ": " + responseWrapper.getBody());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("HTTP response is {}: {}", (Object)responseWrapper.getCode(), (Object)responseWrapper.getMessage());
        }
        this.updateConnectorStorage(responseWrapper);
    }

    @Override
    @Nonnull
    protected String getAuthorizationHeaderValue() {
        String accessToken = this.getStoredAccessToken().orElse("");
        if (accessToken.isEmpty()) {
            logger.warn("Access Token is empty, Authentication will fail.");
        }
        return "Bearer " + accessToken;
    }

    private void updateConnectorStorage(@Nonnull ResponseWrapper responseWrapper) throws AccessTokenException {
        String expiresIn;
        StructuredData responseData = responseWrapper.getBodyAsStructuredData();
        String accessToken = responseData.findString(OAUTH_RESPONSE_KEY_ACCESS_TOKEN_EXPRESSION);
        if (accessToken == null) {
            logger.warn("No access token in response");
            this.resetAuthorization();
            throw new AccessTokenException(responseWrapper.getCode(), responseWrapper.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Storing Access Token {}...{}", (Object)accessToken.substring(0, 5), (Object)accessToken.substring(accessToken.length() - 5));
        }
        this.setConnectorStorageValue("ACCESS_TOKEN", accessToken);
        String refreshToken = responseData.findString(OAUTH_RESPONSE_KEY_REFRESH_TOKEN_EXPRESSION);
        if (refreshToken != null) {
            logger.debug("Storing Refresh Token {}", (Object)refreshToken);
            this.setConnectorStorageValue("REFRESH_TOKEN", refreshToken);
        }
        if ((expiresIn = responseData.findString(OAUTH_RESPONSE_KEY_EXPIRES_IN_EXPRESSION)) != null) {
            long expiresInLong = Long.parseLong(expiresIn);
            Instant expirationDate = Instant.now().plusSeconds(expiresInLong);
            logger.debug("Updating expiration date to {}", (Object)expirationDate);
            String expirationDateString = String.valueOf(expirationDate.toEpochMilli());
            this.setConnectorStorageValue("ACCESS_TOKEN_EXPIRY_DATE", expirationDateString);
        } else {
            logger.debug("No expires_in in response, removing stored expiry date");
            this.removeConnectorStorageValue("ACCESS_TOKEN_EXPIRY_DATE");
        }
    }

    @Override
    public void resetAuthorization() {
        this.removeConnectorStorageValue("ACCESS_TOKEN");
        this.removeConnectorStorageValue("REFRESH_TOKEN");
        this.removeConnectorStorageValue("ACCESS_TOKEN_EXPIRY_DATE");
    }

    protected boolean isTokenValid(String token) {
        long accessTokenExpirationDate = Long.parseLong(this.getConnectorStorageValue("ACCESS_TOKEN_EXPIRY_DATE").orElse("0"));
        if (accessTokenExpirationDate > 0L) {
            Instant expirationDate = Instant.ofEpochMilli(accessTokenExpirationDate);
            return expirationDate.isAfter(Instant.now());
        }
        return false;
    }

    protected boolean isStoredAccessTokenInvalid() {
        Optional<String> optionalStoredAccessToken = this.getStoredAccessToken();
        return !optionalStoredAccessToken.filter(this::isTokenValid).isPresent();
    }

    @Nonnull
    protected Optional<String> getStoredAccessToken() {
        return this.getConnectorStorageValue("ACCESS_TOKEN");
    }
}

