/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.RequestFailedException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractConnector;
import de.resolution.usersync.spi.HTTPConnectorConfiguration;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPConnector<T extends HTTPConnectorConfiguration>
extends AbstractConnector<T> {
    @Nonnull
    protected static final String HEADER_KEY_AUTHORIZATION = "Authorization";
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTTPConnector.class);
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    @Nonnull
    protected final HTTPWrapper httpWrapper;
    @Nonnull
    private final Random random = new SecureRandom();

    protected AbstractHTTPConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, @Nullable String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
        this.httpWrapper = new HTTPWrapper(configuration.getConnectTimeout(), configuration.getReadTimeout(), configuration.getHttpLogLevel());
    }

    @Override
    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp() {
        return true;
    }

    @Nonnull
    protected ResponseWrapper performGetRequest(@Nonnull String url, @Nonnull SyncStatusFacade syncStatusFacade) {
        return this.performGetRequest(url, true, true, syncStatusFacade);
    }

    @Nonnull
    protected ResponseWrapper performGetRequest(@Nonnull String url, boolean applyRateLimitRules, @Nonnull SyncStatusFacade syncStatusFacade) {
        return this.performGetRequest(url, applyRateLimitRules, true, syncStatusFacade);
    }

    @Nonnull
    protected ResponseWrapper performGetRequest(@Nonnull String url, boolean applyRateLimitRules, boolean retryRequestOnError, @Nonnull SyncStatusFacade syncStatusFacade) {
        return this.performGetRequest(url, applyRateLimitRules, 0, retryRequestOnError ? ((HTTPConnectorConfiguration)this.configuration).getMaxRetries() : 0, syncStatusFacade);
    }

    @Nonnull
    private ResponseWrapper performGetRequest(@Nonnull String url, boolean applyRateLimitRules, int retryCount, int maxRetries, @Nonnull SyncStatusFacade syncStatusFacade) {
        ResponseWrapper responseWrapper = this.httpWrapper.get(url, Collections.singletonMap(HEADER_KEY_AUTHORIZATION, this.getAuthorizationHeaderValue()));
        if (responseWrapper.getCode() == 401 || responseWrapper.getCode() == 403) {
            if (retryCount > 0) {
                if (responseWrapper.getCode() == 401) {
                    responseWrapper.setErrorMessage("Backend returned status 401 Unauthorized. Please check if your credentials are still valid.");
                }
                if (responseWrapper.getCode() == 403) {
                    responseWrapper.setErrorMessage("Backend returned status 403 Forbidden. You're not authorized to request this resource.");
                }
                return responseWrapper;
            }
            if (!this.reauthenticateConnector()) {
                responseWrapper.setErrorMessage("Unable to reauthenticate connector.");
                return responseWrapper;
            }
            return this.performGetRequest(url, applyRateLimitRules, retryCount + 1, maxRetries, syncStatusFacade);
        }
        if (responseWrapper.getCode() == 429) {
            try {
                this.applyRateLimitRulesAndWait(responseWrapper, retryCount, maxRetries, syncStatusFacade);
            }
            catch (RequestFailedException e) {
                return new ResponseWrapper(e);
            }
            return this.performGetRequest(url, applyRateLimitRules, retryCount + 1, maxRetries, syncStatusFacade);
        }
        if (responseWrapper.getCode() >= 500) {
            try {
                this.applyExponentialBackoffAndWait(retryCount, maxRetries, syncStatusFacade);
            }
            catch (RequestFailedException e) {
                return new ResponseWrapper(e);
            }
            return this.performGetRequest(url, applyRateLimitRules, retryCount + 1, maxRetries, syncStatusFacade);
        }
        return responseWrapper;
    }

    protected abstract boolean reauthenticateConnector();

    protected void applyRateLimitRulesAndWait(@Nonnull ResponseWrapper responseWrapper, int retryCount, int maxRetries, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        this.applyExponentialBackoffAndWait(retryCount, maxRetries, syncStatusFacade);
    }

    protected void applyExponentialBackoffAndWait(int retryCount, int maxRetries, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        if (retryCount >= maxRetries - 1) {
            throw new RequestFailedException("Request failed after max retries");
        }
        try {
            double waitingTimeInMilliseconds = Math.pow(2.0, (double)retryCount + 1.0) * 1000.0 + (double)this.random.nextInt(1000);
            syncStatusFacade.add("Retry request after " + waitingTimeInMilliseconds + " ms.", SyncStatusFacade.LogLevel.DEBUG, logger);
            Thread.sleep((long)waitingTimeInMilliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RequestFailedException("Request retryRequestOnError interrupted: " + e.getMessage(), e);
        }
    }

    @Nonnull
    protected abstract String getAuthorizationHeaderValue();
}

