/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.config;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.impl.FieldCombinerTransformer;
import de.resolution.retransform.impl.FirstAttributeTransformer;
import de.resolution.retransform.impl.GroovyAttributeTransformer;
import de.resolution.retransform.impl.PostTransformingAttributeTransformer;
import de.resolution.retransform.impl.SingleAttributeTransformer;
import de.resolution.retransform.impl.StaticValueAttributeTransformer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttributeTransformationConfigTranslator {
    @Nonnull
    private final List<AttributeTransformationConfig> attributeTransformationConfigs;
    @Nonnull
    private String profilePrefix = "";
    private String defaultTopLevelKey = null;
    private boolean handleValuesAsExpressions = false;
    @Nonnull
    private Map<String, List<String>> dropAllIfValuesDontMatchAnyOfThese = Collections.emptyMap();
    @Nonnull
    private Map<String, List<String>> removeValuesNotMatchingAnyOfThese = Collections.emptyMap();
    @Nonnull
    private Map<String, List<String>> removeValuesMatchingAnyOfThese = Collections.emptyMap();
    @Nonnull
    private Map<String, List<String>> addTheseStaticValues = Collections.emptyMap();
    @Nullable
    private AtlasUserAdapter atlasUserAdapter;

    @Nonnull
    public static AttributeTransformer translate(@Nonnull AttributeTransformationConfig attributeTransformationConfig, boolean handleValuesAsExpressions, @Nullable String defaultTopLevelKey) {
        return new AttributeTransformationConfigTranslator(Collections.singletonList(attributeTransformationConfig)).withHandleValuesAsExpressions(handleValuesAsExpressions).withDefaultTopLevelKey(defaultTopLevelKey).translate().values().iterator().next();
    }

    @Nonnull
    public AttributeTransformationConfigTranslator(@Nonnull List<AttributeTransformationConfig> attributeTransformationConfigs) {
        this.attributeTransformationConfigs = attributeTransformationConfigs;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withProfilePrefix(@Nonnull String profilePrefix) {
        this.profilePrefix = profilePrefix;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withHandleValuesAsExpressions(boolean handleValuesAsExpressions) {
        this.handleValuesAsExpressions = handleValuesAsExpressions;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withDefaultTopLevelKey(@Nullable String defaultTopLevelKey) {
        this.defaultTopLevelKey = defaultTopLevelKey;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withDropAllIfValuesDontMatchAnyOfThese(@Nonnull Map<String, List<String>> dropAllIfValuesDontMatchAnyOfThese) {
        this.dropAllIfValuesDontMatchAnyOfThese = dropAllIfValuesDontMatchAnyOfThese;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withRemoveValuesNotMatchingAnyOfThese(@Nonnull Map<String, List<String>> removeValuesNotMatchingAnyOfThese) {
        this.removeValuesNotMatchingAnyOfThese = removeValuesNotMatchingAnyOfThese;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withRemoveValuesMatchingAnyOfThese(@Nonnull Map<String, List<String>> removeValuesMatchingAnyOfThese) {
        this.removeValuesMatchingAnyOfThese = removeValuesMatchingAnyOfThese;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withAddTheseStaticValues(@Nonnull Map<String, List<String>> addTheseStaticValues) {
        this.addTheseStaticValues = addTheseStaticValues;
        return this;
    }

    @Nonnull
    public AttributeTransformationConfigTranslator withAtlasUserAdapter(@Nullable AtlasUserAdapter atlasUserAdapter) {
        this.atlasUserAdapter = atlasUserAdapter;
        return this;
    }

    @Nonnull
    public Map<String, AttributeTransformer> translate() {
        HashMap<String, AttributeTransformer> attributeTransformerMap = new HashMap<String, AttributeTransformer>();
        for (AttributeTransformationConfig config : this.attributeTransformationConfigs) {
            String targetString;
            if (config.getSource().getType() == Source.Type.UNMAPPED) continue;
            switch (config.getTarget().getType()) {
                case SYSTEM: 
                case CROWD: {
                    targetString = config.getTarget().getName();
                    break;
                }
                case PROFILE: {
                    targetString = String.valueOf(this.profilePrefix) + config.getTarget().getName();
                    break;
                }
                case CONFLUENCE_CP: 
                case LINCHPIN: {
                    targetString = "CONFLUENCE.CP." + config.getTarget().getName();
                    break;
                }
                case JIRA_EPROP: {
                    targetString = "JIRA.EPROP." + config.getTarget().getName();
                    break;
                }
                default: {
                    targetString = "UNKNOWN." + config.getTarget().getName();
                }
            }
            AttributeTransformer attributeTransformer = this.createTransformer(config.getSource());
            PostTransformingAttributeTransformer postTransformingAttributeTransformer = new PostTransformingAttributeTransformer(attributeTransformer, config.getTransformations(), this.dropAllIfValuesDontMatchAnyOfThese.get(targetString), this.removeValuesNotMatchingAnyOfThese.get(targetString), this.removeValuesMatchingAnyOfThese.get(targetString), this.addTheseStaticValues.get(targetString));
            attributeTransformerMap.put(targetString, postTransformingAttributeTransformer);
        }
        this.addTheseStaticValues.entrySet().stream().filter(entry -> !attributeTransformerMap.containsKey(entry.getKey())).forEach(entry -> {
            StaticValueAttributeTransformer staticValueAttributeTransformer = attributeTransformerMap.put((String)entry.getKey(), new StaticValueAttributeTransformer((List)entry.getValue()));
        });
        return attributeTransformerMap;
    }

    @Nonnull
    public AttributeTransformer createTransformer(@Nonnull Source source2) {
        switch (source2.getType()) {
            case SINGLE: {
                return new SingleAttributeTransformer(source2.getKey(), this.handleValuesAsExpressions, this.defaultTopLevelKey);
            }
            case FIRST: {
                return new FirstAttributeTransformer(source2.getFields(), this.handleValuesAsExpressions, this.defaultTopLevelKey);
            }
            case FIELD_COMBINER: {
                return new FieldCombinerTransformer(source2.getFieldCombinerExpression(), this.handleValuesAsExpressions, this.defaultTopLevelKey);
            }
            case GROOVY: {
                return new GroovyAttributeTransformer(source2.getGroovyCode(), this.defaultTopLevelKey, this.atlasUserAdapter);
            }
        }
        throw new IllegalArgumentException("Invalid source type " + (Object)((Object)source2.getType()));
    }
}

