/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.confluence;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.Group;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@ExportAsService
public class ConfluenceUtil {
    private final UserAccessor userAccessor;
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceUtil.class);
    private final SpacePermissionManager spacePermissionManager;

    @Autowired
    public ConfluenceUtil(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport SpacePermissionManager spacePermissionManager) {
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
    }

    @Nonnull
    public Optional<ConfluenceUser> findExecutionUser() {
        Optional<String> executionUsernameOptional = this.findExecutionUserName();
        if (executionUsernameOptional.isPresent()) {
            String executionUserName = executionUsernameOptional.get();
            logger.debug("Using {} as execution user", (Object)executionUserName);
            return Optional.of(this.userAccessor.getUserByName(executionUserName));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> findExecutionUserName() {
        Optional<Group> adminGroupOptional = this.findAnAdminGroup();
        if (!adminGroupOptional.isPresent()) {
            return Optional.empty();
        }
        Group adminGroup = adminGroupOptional.get();
        List membersOfAdminGroup = this.userAccessor.getMemberNamesAsList(adminGroup);
        Optional<String> adminUser = membersOfAdminGroup.stream().filter(username -> username.equalsIgnoreCase("admin")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser;
        }
        adminUser = membersOfAdminGroup.stream().filter(username -> username.equalsIgnoreCase("administrator")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser;
        }
        adminUser = membersOfAdminGroup.stream().filter(username -> username.toLowerCase().contains("admin")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser;
        }
        String first = (String)membersOfAdminGroup.get(0);
        logger.debug("Returning first member of confluence-users {}", (Object)first);
        return Optional.of(first);
    }

    @Nonnull
    public Optional<Group> findAnAdminGroup() {
        if (this.spacePermissionManager.groupHasPermission("SYSTEMADMINISTRATOR", null, "confluence-administrators")) {
            return Optional.of(this.userAccessor.getGroup("confluence-administrators"));
        }
        Map adminGroups = this.spacePermissionManager.getGroupsForPermissionType("SYSTEMADMINISTRATOR", null);
        if (adminGroups != null && !adminGroups.isEmpty()) {
            for (Map.Entry entry : adminGroups.entrySet()) {
                Group group;
                if (entry.getKey() == null || (group = this.userAccessor.getGroup((String)entry.getKey())) == null) continue;
                return Optional.of(group);
            }
        }
        return Optional.empty();
    }
}

