/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.bamboo;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import de.resolution.atlasuser.api.HostProduct;
import de.resolution.atlasuser.api.HostProductProvider;
import de.resolution.atlasuser.api.UserKeyProvider;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class BambooApplicationAttributeAdapter
implements ApplicationAttributeAdapter,
HostProductProvider {
    private final CrowdService crowdService;

    @Autowired
    public BambooApplicationAttributeAdapter(@BambooImport CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Override
    public HostProduct getHostProduct() {
        return HostProduct.BAMBOO;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.emptyList();
    }

    @Override
    public AtlasUserResultBuilder updateApplicationAttributes(com.atlassian.crowd.model.user.User crowdUser, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        return resultBuilder;
    }

    @Override
    public AtlasUserBuilder readApplicationAttributes(com.atlassian.crowd.model.user.User crowdUser, AtlasUserBuilder atlasUserBuilder, @Nullable Collection<String> knownKeys) {
        atlasUserBuilder.with("ATTR_USER_KEY", crowdUser.getName());
        return atlasUserBuilder;
    }

    @Override
    @Nullable
    public String getUsernameForKey(@Nonnull String key) {
        return key;
    }

    @Override
    @Nullable
    public String getUserKeyForUsername(@Nonnull String username) {
        return username;
    }

    @Override
    @Nullable
    public UserKeyProvider.UsernameAndDirectory getUsernameAndDirectoryForUserKey(@Nonnull String userKey) {
        User crowdUser = this.crowdService.getUser(userKey);
        if (crowdUser == null) {
            return null;
        }
        return new UserKeyProvider.UsernameAndDirectory(crowdUser.getName(), crowdUser.getDirectoryId());
    }
}

