/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.impl.user.AbstractAttributeFilter;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LongAttributeFilter
extends AbstractAttributeFilter {
    private final long compareToValue;

    private LongAttributeFilter(long compareToValue, String ... attributeNames) {
        super(attributeNames);
        this.compareToValue = compareToValue;
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    protected abstract boolean test(long var1, long var3);

    @Override
    public boolean test(Map<String, Set<String>> valueMap) {
        for (String key : this.getAttributeNames()) {
            Set<String> values2 = valueMap.get(key);
            if (values2 == null || values2.isEmpty()) continue;
            try {
                long longValue = Long.parseLong(values2.iterator().next());
                return this.test(longValue, this.compareToValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static class LowerOrEqualLongAttributeFilter
    extends LongAttributeFilter {
        public LowerOrEqualLongAttributeFilter(long compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        protected boolean test(long longValue, long compareToValue) {
            return longValue <= compareToValue;
        }
    }

    public static class LowerLongAttributeFilter
    extends LongAttributeFilter {
        public LowerLongAttributeFilter(long compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        protected boolean test(long longValue, long compareToValue) {
            return longValue < compareToValue;
        }
    }

    public static class GreaterOrEqualLongAttributeFilter
    extends LongAttributeFilter {
        public GreaterOrEqualLongAttributeFilter(long compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        protected boolean test(long longValue, long compareToValue) {
            return longValue >= compareToValue;
        }
    }

    public static class GreaterLongAttributeFilter
    extends LongAttributeFilter {
        public GreaterLongAttributeFilter(long compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        protected boolean test(long longValue, long compareToValue) {
            return longValue > compareToValue;
        }
    }

    public static class EqualLongAttributeFilter
    extends LongAttributeFilter {
        public EqualLongAttributeFilter(long compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        protected boolean test(long longValue, long compareToValue) {
            return longValue == compareToValue;
        }
    }
}

