/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.impl.group.AtlasGroupResultBuilder;
import de.resolution.atlasuser.impl.group.CrowdApiAtlasGroupAdapter;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.SetUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class CrowdApiAtlasGroupCreator {
    private final DirectoryManager directoryManager;
    private static final Set<String> TAGS_TO_CREATE_GROUPS_WITH = SetUtil.of("ATTR_CREATE_GROUPS_WITH_TAGS");

    @Inject
    public CrowdApiAtlasGroupCreator(@ComponentImport DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    private boolean groupExists(AtlasGroupReference reference) throws OperationFailedException {
        try {
            this.directoryManager.findGroupWithAttributesByName(reference.getDirectoryId(), reference.getGroupName());
            return true;
        }
        catch (DirectoryNotFoundException | GroupNotFoundException e) {
            return false;
        }
    }

    @Nonnull
    public AtlasGroupResult create(@Nonnull AtlasGroup atlasGroup) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(atlasGroup.getReference()).inputGroup(atlasGroup);
        try {
            if (this.groupExists(atlasGroup.getReference())) {
                return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_UNIQUE).errorString(atlasGroup.getReference() + " already exists").build();
            }
            GroupTemplate groupTemplate = new GroupTemplate(atlasGroup.getGroupName(), atlasGroup.getReference().getDirectoryId());
            Group createdGroup = this.directoryManager.addGroup(atlasGroup.getReference().getDirectoryId(), groupTemplate);
            GroupWithAttributes groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(createdGroup.getDirectoryId(), createdGroup.getName());
            resultBuilder = this.updateCrowdAttributes(groupWithAttributes, atlasGroup, CrowdApiAtlasGroupCreator.getTagsToCreateGroupsWith(atlasGroup), resultBuilder);
            groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(createdGroup.getDirectoryId(), createdGroup.getName());
            resultBuilder.resultingGroup(CrowdApiAtlasGroupAdapter.buildAtlasGroup(groupWithAttributes));
            resultBuilder.operation(AtlasGroupResult.Operation.ADDED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | InvalidGroupException | OperationFailedException | DirectoryPermissionException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Nonnull
    AtlasGroupResultBuilder updateCrowdAttributes(@Nonnull GroupWithAttributes group, @Nonnull AtlasGroup atlasGroup, @Nonnull Set<String> createNonExistingWithTheseTags, @Nonnull AtlasGroupResultBuilder resultBuilder) {
        try {
            Set attributeNames = atlasGroup.getAttributeKeys().stream().filter(key -> !CrowdApiAtlasGroupAdapter.SPECIAL_ATTRIBUTES.contains(key)).filter(key -> AtlasUserKeys.APPLICATION_PREFIXES.stream().noneMatch(key::startsWith)).collect(Collectors.toSet());
            Set crowdUserKeys = group.getKeys();
            Set keysToRemove = crowdUserKeys.stream().filter(key -> attributeNames.contains(key) && atlasGroup.getAttributeValues((String)key).isEmpty()).collect(Collectors.toSet());
            Set keysToAdd = attributeNames.stream().filter(key -> !atlasGroup.getAttributeValues((String)key).isEmpty() && !crowdUserKeys.contains(key)).collect(Collectors.toSet());
            HashMap<String, Set<String>> attributesToAdd = new HashMap<String, Set<String>>();
            for (String key2 : keysToAdd) {
                attributesToAdd.put(key2, atlasGroup.getAttributeValues(key2));
            }
            createNonExistingWithTheseTags.forEach(tag -> attributesToAdd.put((String)tag, Collections.singleton("true")));
            Set keysToUpdate = attributeNames.stream().filter(key -> !atlasGroup.getAttributeValues((String)key).isEmpty() && crowdUserKeys.contains(key) && !CollectionUtil.containsSame(atlasGroup.getAttributeValues((String)key), group.getValues(key))).collect(Collectors.toSet());
            boolean updated = false;
            for (String key3 : keysToRemove) {
                this.directoryManager.removeGroupAttributes(group.getDirectoryId(), group.getName(), key3);
                updated = true;
            }
            if (!attributesToAdd.isEmpty()) {
                this.directoryManager.storeGroupAttributes(group.getDirectoryId(), group.getName(), attributesToAdd);
                updated = true;
            }
            HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
            for (String key4 : keysToUpdate) {
                attributesToUpdate.put(key4, atlasGroup.getAttributeValues(key4));
            }
            if (!attributesToUpdate.isEmpty()) {
                this.directoryManager.storeGroupAttributes(group.getDirectoryId(), group.getName(), attributesToUpdate);
                updated = true;
            }
            if (updated) {
                resultBuilder.operation(resultBuilder.getOperation() == AtlasGroupResult.Operation.ADDED ? AtlasGroupResult.Operation.ADDED : AtlasGroupResult.Operation.UPDATED);
            }
            return resultBuilder;
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | DirectoryPermissionException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).errorString("Updating attributes for group " + group.getName() + " in directory " + group.getDirectoryId() + " failed");
        }
    }

    @Nonnull
    private static Set<String> getTagsToCreateGroupsWith(@Nonnull AtlasGroup atlasGroup) {
        return atlasGroup.getAttributes().entrySet().stream().filter(entry -> TAGS_TO_CREATE_GROUPS_WITH.contains(entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }
}

