/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.resolution.atlasuser.api.LicenseCountProvider;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
@ExportAsService(value={LicenseCountProvider.class})
public class JiraLicenseCountProvider
implements LicenseCountProvider {
    private final ApplicationRoleManager applicationRoleManager;
    private static final ApplicationKey CORE = ApplicationKey.valueOf((String)"jira-core");
    private static final ApplicationKey SOFTWARE = ApplicationKey.valueOf((String)"jira-software");
    private static final ApplicationKey SERVICE_DESK = ApplicationKey.valueOf((String)"jira-servicedesk");

    @Autowired
    public JiraLicenseCountProvider(@JiraComponent ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = applicationRoleManager;
    }

    private int maxIntIfUnlimited(int count) {
        if (count == -1) {
            return Integer.MAX_VALUE;
        }
        return count;
    }

    @Override
    public int getAvailableJiraCoreUserLicenses() {
        return this.maxIntIfUnlimited(this.applicationRoleManager.getRemainingSeats(CORE));
    }

    @Override
    public int getAvailableJiraSoftwareUserLicenses() {
        return this.maxIntIfUnlimited(this.applicationRoleManager.getRemainingSeats(SOFTWARE));
    }

    @Override
    public int getAvailableJSMUserLicenses() {
        return this.maxIntIfUnlimited(this.applicationRoleManager.getRemainingSeats(SERVICE_DESK));
    }
}

