/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.AtlasUserDirectoryBuilder;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.atlasuser.impl.ChangedDirectory;
import de.resolution.commons.util.MapUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CrowdApiDirectoryAdapter
implements DirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdApiDirectoryAdapter.class);
    private static final String ATLAS_USER_DIRECTORY_ATTRIBUTE = "ATLAS_USER_DIRECTORY";
    private static final String ATTRIBUTE_PREFIX = "ATLAS_USER_ATTR_";
    private static final String ATTRIBUTE_USE_NESTED_GROUPS = "useNestedGroups";
    private final List<String> directoryAttributesNotToIncludeInSupportInfo = Arrays.asList("ldap.password", "ldap.url", "application.password", "crowd.server.url");
    private final CrowdDirectoryService crowdDirectoryService;
    private final TransactionTemplate transactionTemplate;
    private static final Set<OperationType> ALLOWED_OPERATIONS;

    @Autowired
    public CrowdApiDirectoryAdapter(@ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nonnull
    public Long getFirstWritableDirectoryId() {
        return (Long)this.transactionTemplate.execute(() -> {
            for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
                if (!directory.isActive() || !directory.getAllowedOperations().contains(OperationType.CREATE_USER) || !directory.getAllowedOperations().contains(OperationType.UPDATE_USER) || !directory.getAllowedOperations().contains(OperationType.UPDATE_USER_ATTRIBUTE)) continue;
                logger.debug("First writable Directory is {} with reference {}", (Object)directory.getName(), (Object)directory.getId());
                return directory.getId();
            }
            throw new AtlasUserRuntimeException("There is no writable directory");
        });
    }

    @Override
    @Nonnull
    public AtlasUserDirectory update(AtlasUserDirectory directoryEntity) throws DirectoryNotFoundException, InvalidOperationException, DirectoryNameExistsAlreadyException {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryEntity.getId());
        if (directory == null) {
            throw new DirectoryNotFoundException(directoryEntity.getId());
        }
        if (this.isAtlasUser(directory)) {
            if (this.getDirectories().stream().anyMatch(dir -> directory.getId().longValue() != directoryEntity.getId() && dir.getName().equals(directoryEntity.getName()))) {
                throw new DirectoryNameExistsAlreadyException(directory.getName());
            }
            HashMap<String, String> updatedAttributes = new HashMap<String, String>(directory.getAttributes());
            for (Map.Entry<String, String> entry : directoryEntity.getAttributes().entrySet()) {
                updatedAttributes.put(ATTRIBUTE_PREFIX + entry.getKey(), entry.getValue());
            }
            Directory updated = this.crowdDirectoryService.updateDirectory((Directory)new ChangedDirectory(directory, directoryEntity.getName(), directoryEntity.getDescription(), updatedAttributes, directoryEntity.isActive()));
            return this.from(updated);
        }
        throw new InvalidOperationException(directory.getId() + " is no AtlasUser-directory");
    }

    @Override
    public void delete(long directoryId) throws DirectoryNotFoundException, InvalidOperationException, AtlasUserOperationFailedException {
        Exception ret = (Exception)this.transactionTemplate.execute(() -> {
            Directory dir = this.crowdDirectoryService.findDirectoryById(directoryId);
            if (dir == null) {
                return new DirectoryNotFoundException(directoryId);
            }
            if (this.isAtlasUser(dir)) {
                try {
                    this.crowdDirectoryService.removeDirectory(directoryId);
                }
                catch (DirectoryCurrentlySynchronisingException e) {
                    return new AtlasUserOperationFailedException("Directory cannot be deleted now, try again later", e);
                }
            } else {
                return new InvalidOperationException("Deleting non-AtlasUser-directories is not allowed");
            }
            return null;
        });
        if (ret != null) {
            this.throwException(ret);
        }
    }

    private void throwException(Exception ex) throws DirectoryNotFoundException, InvalidOperationException, AtlasUserOperationFailedException {
        if (ex instanceof DirectoryNotFoundException) {
            throw (DirectoryNotFoundException)ex;
        }
        if (ex instanceof InvalidOperationException) {
            throw (InvalidOperationException)ex;
        }
        if (ex instanceof AtlasUserOperationFailedException) {
            throw (AtlasUserOperationFailedException)ex;
        }
    }

    @Override
    @Nonnull
    public AtlasUserDirectory create(AtlasUserDirectory directoryEntity) throws DirectoryNameExistsAlreadyException {
        boolean directoryNameAlreadyExists = (Boolean)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().anyMatch(directory -> Objects.equals(directory.getName(), directoryEntity.getName())));
        if (directoryNameAlreadyExists) {
            throw new DirectoryNameExistsAlreadyException(directoryEntity.getName());
        }
        DirectoryImpl newDirectory = new DirectoryImpl();
        newDirectory.setActive(directoryEntity.isActive());
        newDirectory.setAllowedOperations(ALLOWED_OPERATIONS);
        newDirectory.setType(DirectoryType.INTERNAL);
        newDirectory.setName(directoryEntity.getName());
        newDirectory.setDescription(directoryEntity.getDescription());
        newDirectory.setImplementationClass(InternalDirectory.class.getName());
        newDirectory.setAttribute("user_encryption_method", "atlassian-security");
        newDirectory.setAttribute(ATLAS_USER_DIRECTORY_ATTRIBUTE, "true");
        for (Map.Entry<String, String> entry : directoryEntity.getAttributes().entrySet()) {
            newDirectory.setAttribute(ATTRIBUTE_PREFIX + entry.getKey(), entry.getValue());
        }
        newDirectory.setAttribute("DUMMY1", "this is to avoid an Exception ");
        newDirectory.setAttribute("DUMMY2", "Attempting to store directory [10040] with only 2 attributes");
        newDirectory.setAttribute("DUMMY3", "to be logged.");
        if (directoryEntity.isUseNestedGroups()) {
            newDirectory.setAttribute(ATTRIBUTE_USE_NESTED_GROUPS, "true");
        }
        Directory persistedDirectory = (Directory)this.transactionTemplate.execute(() -> this.crowdDirectoryService.addDirectory((Directory)newDirectory));
        return this.from(persistedDirectory);
    }

    private AtlasUserDirectory from(Directory directory) {
        AtlasUserDirectoryBuilder builder = AtlasUserDirectory.builder().id(directory.getId()).name(directory.getName()).description(directory.getDescription()).writable(this.isWritable(directory)).atlasUser(this.isAtlasUser(directory)).active(directory.isActive()).internal(this.isInternal(directory)).useNestedGroups("true".equals(directory.getAttributes().get(ATTRIBUTE_USE_NESTED_GROUPS)));
        for (Map.Entry entry : directory.getAttributes().entrySet()) {
            if (!((String)entry.getKey()).startsWith(ATTRIBUTE_PREFIX)) continue;
            builder.with(((String)entry.getKey()).replaceFirst(ATTRIBUTE_PREFIX, ""), (String)entry.getValue());
        }
        return builder.build();
    }

    private AtlasUserDirectory allAttributesButSanitizedFrom(Directory directory) {
        AtlasUserDirectoryBuilder builder = AtlasUserDirectory.builder().id(directory.getId()).name(directory.getName()).description(directory.getDescription()).writable(this.isWritable(directory)).atlasUser(this.isAtlasUser(directory)).active(directory.isActive()).internal(this.isInternal(directory)).useNestedGroups("true".equals(directory.getAttributes().get(ATTRIBUTE_USE_NESTED_GROUPS)));
        directory.getAttributes().forEach((key, value) -> {
            if (!this.directoryAttributesNotToIncludeInSupportInfo.contains(key)) {
                builder.with((String)key, (String)value);
            }
        });
        return builder.build();
    }

    @Override
    public AtlasUserDirectory get(long id) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(id);
        if (directory == null) {
            return null;
        }
        return this.from(directory);
    }

    @Override
    public List<AtlasUserDirectory> get(String name) {
        return this.getDirectories().stream().filter(directory -> Objects.equals(name, directory.getName())).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<AtlasUserDirectory> getDirectories() {
        return (List)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().map(this::from).collect(Collectors.toList()));
    }

    @Override
    public boolean exists(@Nonnull String directoryName) {
        return this.getDirectories().stream().anyMatch(directoryEntity -> Objects.equals(directoryEntity.getName(), directoryName));
    }

    @Override
    @Nonnull
    public List<AtlasUserDirectory> getAtlasUserDirectories() {
        return (List)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().filter(this::isWritable).filter(this::isAtlasUser).map(this::from).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<AtlasUserDirectory> getWritableDirectories() {
        return (List)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().filter(this::isWritable).map(this::from).collect(Collectors.toList()));
    }

    @Override
    public boolean isApplicable(long directoryId) {
        Directory dir = this.crowdDirectoryService.findDirectoryById(directoryId);
        return this.isAtlasUser(dir);
    }

    @Override
    public boolean isWritable(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        return this.isWritable(directory);
    }

    @Override
    public boolean isAtlasUser(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        return this.isAtlasUser(directory);
    }

    @Override
    public boolean isUseNestedGroups(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        Map attributes = directory.getAttributes();
        return attributes != null && "true".equals(attributes.get(ATTRIBUTE_USE_NESTED_GROUPS));
    }

    @Override
    public boolean isActive(long directoryId) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        return this.isActive(directory);
    }

    private boolean isAtlasUser(Directory directory) {
        return directory != null && directory.getAttributes().containsKey(ATLAS_USER_DIRECTORY_ATTRIBUTE);
    }

    private boolean isInternal(Directory directory) {
        return directory.getType() == DirectoryType.INTERNAL;
    }

    private boolean isWritable(Directory directory) {
        return directory != null && (this.isAtlasUser(directory) || directory.getAllowedOperations().contains(OperationType.CREATE_USER)) && directory.getAllowedOperations().contains(OperationType.CREATE_GROUP) && directory.getAllowedOperations().contains(OperationType.DELETE_GROUP) && directory.getAllowedOperations().contains(OperationType.DELETE_USER) && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP) && directory.getAllowedOperations().contains(OperationType.UPDATE_USER) && directory.getAllowedOperations().contains(OperationType.UPDATE_USER_ATTRIBUTE);
    }

    private boolean isActive(Directory directory) {
        return directory != null && directory.isActive();
    }

    @Override
    public boolean exists(long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId) != null;
    }

    @Override
    public void setPosition(long directoryId, int position) {
        this.transactionTemplate.execute(() -> {
            this.crowdDirectoryService.setDirectoryPosition(directoryId, position);
            return 0;
        });
    }

    @Override
    public int getPosition(long directoryId) {
        return (Integer)this.transactionTemplate.execute(() -> {
            List directories = this.crowdDirectoryService.findAllDirectories();
            for (int i = 0; i < directories.size(); ++i) {
                if (((Directory)directories.get(i)).getId() != directoryId) continue;
                return i;
            }
            return -1;
        });
    }

    @Override
    public long getLowestDirectoryId() {
        return (Long)this.transactionTemplate.execute(() -> {
            long directoryId = -1L;
            for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
                if (directoryId != -1L && directory.getId() >= directoryId) continue;
                directoryId = directory.getId();
            }
            return directoryId;
        });
    }

    public List<AtlasUserDirectory> getDirectoriesForSupportInformation() {
        return (List)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().map(this::allAttributesButSanitizedFrom).collect(Collectors.toList()));
    }

    public List<Map<String, Integer>> getDirectoryAnalyticsInformation() {
        HashMap directoryClassOccurrences = new HashMap();
        this.transactionTemplate.execute(() -> {
            this.crowdDirectoryService.findAllDirectories().stream().map(Directory::getImplementationClass).forEach(className -> directoryClassOccurrences.merge(className, 1, Integer::sum));
            return null;
        });
        return directoryClassOccurrences.entrySet().stream().map(entry -> MapUtil.of((String)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    static {
        HashSet<OperationType> allowedOperations = new HashSet<OperationType>();
        allowedOperations.add(OperationType.UPDATE_USER_ATTRIBUTE);
        allowedOperations.add(OperationType.UPDATE_ROLE_ATTRIBUTE);
        allowedOperations.add(OperationType.UPDATE_GROUP_ATTRIBUTE);
        allowedOperations.add(OperationType.CREATE_GROUP);
        allowedOperations.add(OperationType.CREATE_ROLE);
        allowedOperations.add(OperationType.DELETE_GROUP);
        allowedOperations.add(OperationType.DELETE_USER);
        allowedOperations.add(OperationType.UPDATE_GROUP);
        allowedOperations.add(OperationType.UPDATE_USER);
        ALLOWED_OPERATIONS = Collections.unmodifiableSet(allowedOperations);
    }
}

