/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import de.resolution.atlasuser.api.HostProductProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHostProductProvider
implements HostProductProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHostProductProvider.class);

    @Override
    public String getApplicationPrefix() {
        String applicationPrefix;
        switch (this.getHostProduct()) {
            case JIRA: {
                applicationPrefix = "JIRA.PROP.";
                break;
            }
            case CONFLUENCE: {
                applicationPrefix = "CONFLUENCE.UD.";
                break;
            }
            case BITBUCKET: {
                applicationPrefix = "BITBUCKET.";
                logger.warn("Bitbucket-specific attributes are currently not supported");
                break;
            }
            case BAMBOO: {
                applicationPrefix = "BAMBOO.";
                logger.warn("Bamboo-specific attributes are currently not supported");
                break;
            }
            case FECRU: {
                applicationPrefix = "FECRU.";
                logger.warn("FeCru-specific attributes are currently not supported");
                break;
            }
            default: {
                logger.error("Host {} is unknown", (Object)this.getHostProduct());
                applicationPrefix = "UNKNOWN_HOSTPRODUCT.";
            }
        }
        return applicationPrefix;
    }
}

