/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl.jira;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.resolution.atlasauth.impl.DirectoryAdapter;
import de.resolution.atlasauth.impl.DirectoryAdapterImpl;
import de.resolution.atlasauth.impl.RemoteDirectoryAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
@ExportAsService(value={DirectoryAdapter.class})
public class JiraDirectoryAdapter
extends DirectoryAdapterImpl {
    private static final Logger logger = LoggerFactory.getLogger(JiraDirectoryAdapter.class);
    private final EventPublisher eventPublisher;

    @Autowired
    public JiraDirectoryAdapter(RemoteDirectoryAdapter remoteDirectoryAdapter, @JiraImport TransactionTemplate transactionTemplate, @JiraImport DirectoryManager driM, @JiraImport CrowdDirectoryService crowdDirectoryService, @JiraImport EventPublisher eventPublisher) {
        super(remoteDirectoryAdapter, transactionTemplate, driM, crowdDirectoryService);
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void publishJiraBeforeUserAuthenticateEvent(@Nonnull String username) {
        Class<?> eventToFire = null;
        try {
            eventToFire = Class.forName("com.atlassian.jira.event.user.BeforeUserAuthenticate", false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.debug("Looks like the BeforeUserAuthenticate event is not present, thus not firing, bc ", (Throwable)e);
            return;
        }
        Constructor<?> cons = null;
        try {
            cons = eventToFire.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Could no load construction for BeforeUserAuthenticate event: ", (Throwable)e);
            return;
        }
        Object beforeUserAuthenticateEvent = null;
        try {
            beforeUserAuthenticateEvent = cons.newInstance(username);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.debug("Cannot call constructor on BeforeUserAuthenticateEvent because ", (Throwable)e);
            return;
        }
        this.eventPublisher.publish(beforeUserAuthenticateEvent);
        logger.debug("We have sent {}", (Object)beforeUserAuthenticateEvent.getClass().getName());
    }
}

